/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.yaml.swapper;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.datanode.YamlDataNode;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlDataNodeRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.path.RuleNodePath;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.metadata.nodepath.ShardingRuleNodePathProvider;
import org.apache.shardingsphere.sharding.yaml.config.cache.YamlShardingCacheConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.audit.YamlShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.keygen.YamlKeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.cache.YamlShardingCacheConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.YamlShardingAutoTableRuleConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.YamlShardingTableReferenceRuleConfigurationConverter;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.YamlShardingTableRuleConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlKeyGenerateStrategyConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlShardingAuditStrategyConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlShardingStrategyConfigurationSwapper;

public final class YamlShardingDataNodeRuleConfigurationSwapper
implements YamlDataNodeRuleConfigurationSwapper<ShardingRuleConfiguration> {
    private final YamlShardingTableRuleConfigurationSwapper tableSwapper = new YamlShardingTableRuleConfigurationSwapper();
    private final YamlShardingAutoTableRuleConfigurationSwapper autoTableSwapper = new YamlShardingAutoTableRuleConfigurationSwapper();
    private final YamlShardingStrategyConfigurationSwapper shardingStrategySwapper = new YamlShardingStrategyConfigurationSwapper();
    private final YamlKeyGenerateStrategyConfigurationSwapper keyGenerateStrategySwapper = new YamlKeyGenerateStrategyConfigurationSwapper();
    private final YamlShardingAuditStrategyConfigurationSwapper auditStrategySwapper = new YamlShardingAuditStrategyConfigurationSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();
    private final YamlShardingCacheConfigurationSwapper shardingCacheSwapper = new YamlShardingCacheConfigurationSwapper();
    private final RuleNodePath shardingRuleNodePath = new ShardingRuleNodePathProvider().getRuleNodePath();

    public Collection<YamlDataNode> swapToDataNodes(ShardingRuleConfiguration data) {
        LinkedList<YamlDataNode> result = new LinkedList<YamlDataNode>();
        this.swapAlgorithms(data, result);
        this.swapStrategies(data, result);
        if (null != data.getDefaultShardingColumn()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getUniqueItem("default_sharding_column").getPath(), data.getDefaultShardingColumn()));
        }
        if (null != data.getShardingCache()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getUniqueItem("sharding_cache").getPath(), YamlEngine.marshal((Object)this.shardingCacheSwapper.swapToYamlConfiguration(data.getShardingCache()))));
        }
        this.swapTableRules(data, result);
        return result;
    }

    private void swapAlgorithms(ShardingRuleConfiguration data, Collection<YamlDataNode> result) {
        for (Map.Entry each : data.getShardingAlgorithms().entrySet()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getNamedItem("algorithms").getPath((String)each.getKey()), YamlEngine.marshal((Object)this.algorithmSwapper.swapToYamlConfiguration((AlgorithmConfiguration)each.getValue()))));
        }
        for (Map.Entry each : data.getKeyGenerators().entrySet()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getNamedItem("key_generators").getPath((String)each.getKey()), YamlEngine.marshal((Object)this.algorithmSwapper.swapToYamlConfiguration((AlgorithmConfiguration)each.getValue()))));
        }
        for (Map.Entry each : data.getAuditors().entrySet()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getNamedItem("auditors").getPath((String)each.getKey()), YamlEngine.marshal((Object)this.algorithmSwapper.swapToYamlConfiguration((AlgorithmConfiguration)each.getValue()))));
        }
    }

    private void swapStrategies(ShardingRuleConfiguration data, Collection<YamlDataNode> result) {
        if (null != data.getDefaultDatabaseShardingStrategy()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getUniqueItem("default_database_strategy").getPath(), YamlEngine.marshal((Object)this.shardingStrategySwapper.swapToYamlConfiguration(data.getDefaultDatabaseShardingStrategy()))));
        }
        if (null != data.getDefaultTableShardingStrategy()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getUniqueItem("default_table_strategy").getPath(), YamlEngine.marshal((Object)this.shardingStrategySwapper.swapToYamlConfiguration(data.getDefaultTableShardingStrategy()))));
        }
        if (null != data.getDefaultKeyGenerateStrategy()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getUniqueItem("default_key_generate_strategy").getPath(), YamlEngine.marshal((Object)this.keyGenerateStrategySwapper.swapToYamlConfiguration(data.getDefaultKeyGenerateStrategy()))));
        }
        if (null != data.getDefaultAuditStrategy()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getUniqueItem("default_audit_strategy").getPath(), YamlEngine.marshal((Object)this.auditStrategySwapper.swapToYamlConfiguration(data.getDefaultAuditStrategy()))));
        }
    }

    private void swapTableRules(ShardingRuleConfiguration data, Collection<YamlDataNode> result) {
        for (ShardingTableRuleConfiguration each : data.getTables()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getNamedItem("tables").getPath(each.getLogicTable()), YamlEngine.marshal((Object)this.tableSwapper.swapToYamlConfiguration(each))));
        }
        for (ShardingTableRuleConfiguration each : data.getAutoTables()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getNamedItem("auto_tables").getPath(each.getLogicTable()), YamlEngine.marshal((Object)this.autoTableSwapper.swapToYamlConfiguration((ShardingAutoTableRuleConfiguration)each))));
        }
        for (ShardingTableRuleConfiguration each : data.getBindingTableGroups()) {
            result.add(new YamlDataNode(this.shardingRuleNodePath.getNamedItem("binding_tables").getPath(each.getName()), YamlShardingTableReferenceRuleConfigurationConverter.convertToYamlString((ShardingTableReferenceRuleConfiguration)each)));
        }
    }

    public Optional<ShardingRuleConfiguration> swapToObject(Collection<YamlDataNode> dataNodes) {
        List validDataNodes = dataNodes.stream().filter(each -> this.shardingRuleNodePath.getRoot().isValidatedPath(each.getKey())).collect(Collectors.toList());
        if (validDataNodes.isEmpty()) {
            return Optional.empty();
        }
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (YamlDataNode each2 : validDataNodes) {
            this.shardingRuleNodePath.getNamedItem("tables").getName(each2.getKey()).ifPresent(optional -> result.getTables().add(this.tableSwapper.swapToObject((YamlTableRuleConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlTableRuleConfiguration.class))));
            this.shardingRuleNodePath.getNamedItem("auto_tables").getName(each2.getKey()).ifPresent(optional -> result.getAutoTables().add(this.autoTableSwapper.swapToObject((YamlShardingAutoTableRuleConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlShardingAutoTableRuleConfiguration.class))));
            this.shardingRuleNodePath.getNamedItem("binding_tables").getName(each2.getKey()).ifPresent(optional -> result.getBindingTableGroups().add(YamlShardingTableReferenceRuleConfigurationConverter.convertToObject(each2.getValue())));
            this.shardingRuleNodePath.getNamedItem("algorithms").getName(each2.getKey()).ifPresent(optional -> result.getShardingAlgorithms().put(optional, this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlAlgorithmConfiguration.class))));
            this.shardingRuleNodePath.getNamedItem("key_generators").getName(each2.getKey()).ifPresent(optional -> result.getKeyGenerators().put(optional, this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlAlgorithmConfiguration.class))));
            this.shardingRuleNodePath.getNamedItem("auditors").getName(each2.getKey()).ifPresent(optional -> result.getAuditors().put(optional, this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlAlgorithmConfiguration.class))));
            if (this.shardingRuleNodePath.getUniqueItem("default_database_strategy").isValidatedPath(each2.getKey())) {
                result.setDefaultDatabaseShardingStrategy(this.shardingStrategySwapper.swapToObject((YamlShardingStrategyConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlShardingStrategyConfiguration.class)));
                continue;
            }
            if (this.shardingRuleNodePath.getUniqueItem("default_table_strategy").isValidatedPath(each2.getKey())) {
                result.setDefaultTableShardingStrategy(this.shardingStrategySwapper.swapToObject((YamlShardingStrategyConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlShardingStrategyConfiguration.class)));
                continue;
            }
            if (this.shardingRuleNodePath.getUniqueItem("default_key_generate_strategy").isValidatedPath(each2.getKey())) {
                result.setDefaultKeyGenerateStrategy(this.keyGenerateStrategySwapper.swapToObject((YamlKeyGenerateStrategyConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlKeyGenerateStrategyConfiguration.class)));
                continue;
            }
            if (this.shardingRuleNodePath.getUniqueItem("default_audit_strategy").isValidatedPath(each2.getKey())) {
                result.setDefaultAuditStrategy(this.auditStrategySwapper.swapToObject((YamlShardingAuditStrategyConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlShardingAuditStrategyConfiguration.class)));
                continue;
            }
            if (this.shardingRuleNodePath.getUniqueItem("default_sharding_column").isValidatedPath(each2.getKey())) {
                result.setDefaultShardingColumn(each2.getValue());
                continue;
            }
            if (!this.shardingRuleNodePath.getUniqueItem("sharding_cache").isValidatedPath(each2.getKey())) continue;
            result.setShardingCache(this.shardingCacheSwapper.swapToObject((YamlShardingCacheConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlShardingCacheConfiguration.class)));
        }
        return Optional.of(result);
    }

    public Class<ShardingRuleConfiguration> getTypeClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHARDING";
    }

    public int getOrder() {
        return 0;
    }
}

