/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterNamedRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.YamlShardingTableReferenceRuleConfigurationConverter;

public final class ShardingTableReferenceChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, ShardingTableReferenceRuleConfiguration> {
    public ShardingTableReferenceRuleConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return YamlShardingTableReferenceRuleConfigurationConverter.convertToObject(yamlContent);
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, ShardingRuleConfiguration currentRuleConfig, ShardingTableReferenceRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getBindingTableGroups().removeIf(each -> each.getName().equals(((AlterNamedRuleItemEvent)event).getItemName()));
        currentRuleConfig.getBindingTableGroups().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getBindingTableGroups().removeIf(each -> each.getName().equals(((DropNamedRuleItemEvent)event).getItemName()));
    }

    public String getType() {
        return "sharding.binding_tables";
    }
}

