/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.cache.ShardingCacheConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.yaml.config.cache.YamlShardingCacheConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.cache.YamlShardingCacheConfigurationSwapper;

public final class ShardingCacheChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, ShardingCacheConfiguration> {
    public ShardingCacheConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new YamlShardingCacheConfigurationSwapper().swapToObject((YamlShardingCacheConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShardingCacheConfiguration.class));
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, ShardingRuleConfiguration currentRuleConfig, ShardingCacheConfiguration toBeChangedItemConfig) {
        currentRuleConfig.setShardingCache(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setShardingCache(null);
    }

    public String getType() {
        return "sharding.sharding_cache";
    }
}

