/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class DefaultShardingColumnChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, String> {
    public String swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return yamlContent;
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, ShardingRuleConfiguration currentRuleConfig, String toBeChangedItemConfig) {
        currentRuleConfig.setDefaultShardingColumn(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultShardingColumn(null);
    }

    public String getType() {
        return "sharding.default_sharding_column";
    }
}

