/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.attribute;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingTableNamesRuleAttribute
implements TableMapperRuleAttribute {
    private final CaseInsensitiveSet<String> logicalTableNames;
    private final CaseInsensitiveSet<String> actualTableNames;

    public ShardingTableNamesRuleAttribute(Collection<ShardingTable> shardingTables) {
        this.logicalTableNames = this.createLogicalTableNames(shardingTables);
        this.actualTableNames = this.createActualTableNames(shardingTables);
    }

    private CaseInsensitiveSet<String> createLogicalTableNames(Collection<ShardingTable> shardingTables) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        shardingTables.forEach(each -> result.add((Object)each.getLogicTable()));
        return result;
    }

    private CaseInsensitiveSet<String> createActualTableNames(Collection<ShardingTable> shardingTables) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        shardingTables.stream().flatMap(each -> each.getActualDataNodes().stream()).map(DataNode::getTableName).forEach(arg_0 -> ((CaseInsensitiveSet)result).add(arg_0));
        return result;
    }

    public Collection<String> getLogicTableNames() {
        return this.logicalTableNames;
    }

    public Collection<String> getActualTableNames() {
        return this.actualTableNames;
    }

    public Collection<String> getDistributedTableNames() {
        return this.logicalTableNames;
    }

    public Collection<String> getEnhancedTableNames() {
        return this.logicalTableNames;
    }
}

