/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.sharding.exception.connection.ShardingDDLRouteException;
import org.apache.shardingsphere.sharding.exception.metadata.InUsedTablesException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropTableStatementHandler;

public final class ShardingDropTableStatementValidator
extends ShardingDDLStatementValidator {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        DropTableStatement dropTableStatement = (DropTableStatement)sqlStatementContext.getSqlStatement();
        if (!DropTableStatementHandler.ifExists((DropTableStatement)dropTableStatement)) {
            String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
            ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
            this.validateTableExist(schema, sqlStatementContext.getTablesContext().getSimpleTableSegments());
        }
        if (DropTableStatementHandler.containsCascade((DropTableStatement)dropTableStatement)) {
            throw new UnsupportedShardingOperationException("DROP TABLE ... CASCADE", ((SimpleTableSegment)sqlStatementContext.getTablesContext().getSimpleTableSegments().iterator().next()).getTableName().getIdentifier().getValue());
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        DropTableStatement dropTableStatement = (DropTableStatement)sqlStatementContext.getSqlStatement();
        this.checkTableInUsed(shardingRule, sqlStatementContext, routeContext);
        for (SimpleTableSegment each : dropTableStatement.getTables()) {
            if (!this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, each.getTableName().getIdentifier().getValue())) continue;
            throw new ShardingDDLRouteException("DROP", "TABLE", sqlStatementContext.getTablesContext().getTableNames());
        }
    }

    private void checkTableInUsed(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, RouteContext routeContext) {
        Collection dropTables = sqlStatementContext.getTablesContext().getTableNames();
        Collection otherRuleActualTables = (Collection)shardingRule.getShardingTables().values().stream().filter(each -> !dropTables.contains(each.getLogicTable())).flatMap(each -> each.getActualDataNodes().stream().map(DataNode::getTableName)).collect(Collectors.toCollection(CaseInsensitiveSet::new));
        if (otherRuleActualTables.isEmpty()) {
            return;
        }
        Set actualTables = routeContext.getRouteUnits().stream().flatMap(each -> each.getTableMappers().stream().map(RouteMapper::getActualName)).collect(Collectors.toSet());
        Collection inUsedTables = actualTables.stream().filter(otherRuleActualTables::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)inUsedTables.isEmpty(), () -> new InUsedTablesException(inUsedTables));
    }
}

