/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.metadata.EngagedViewException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedCreateViewException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;

public final class ShardingCreateViewStatementValidator
extends ShardingDDLStatementValidator {
    private final RuleMetaData globalRuleMetaData;

    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(((CreateViewStatement)sqlStatementContext.getSqlStatement()).getSelect());
        Collection tableSegments = extractor.getRewriteTables();
        boolean sqlFederationEnabled = ((SQLFederationRule)this.globalRuleMetaData.getSingleRule(SQLFederationRule.class)).getConfiguration().isSqlFederationEnabled();
        if (!sqlFederationEnabled && this.isShardingTablesWithoutBinding(shardingRule, sqlStatementContext, tableSegments)) {
            throw new EngagedViewException("sharding");
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        SelectStatement selectStatement = ((CreateViewStatement)sqlStatementContext.getSqlStatement()).getSelect();
        if (this.isContainsNotSupportedViewStatement(selectStatement, routeContext)) {
            throw new UnsupportedCreateViewException();
        }
    }

    private boolean isShardingTablesWithoutBinding(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, Collection<SimpleTableSegment> tableSegments) {
        for (SimpleTableSegment each : tableSegments) {
            String logicTable = each.getTableName().getIdentifier().getValue();
            if (!shardingRule.isShardingTable(logicTable) || this.isBindingTables(shardingRule, ((CreateViewStatement)sqlStatementContext.getSqlStatement()).getView().getTableName().getIdentifier().getValue(), logicTable)) continue;
            return true;
        }
        return false;
    }

    private boolean isBindingTables(ShardingRule shardingRule, String logicViewName, String logicTable) {
        List<String> bindTables = Arrays.asList(logicTable, logicViewName);
        return shardingRule.isAllBindingTables(bindTables);
    }

    private boolean isContainsNotSupportedViewStatement(SelectStatement selectStatement, RouteContext routeContext) {
        if (routeContext.getRouteUnits().size() <= 1) {
            return false;
        }
        return this.hasGroupBy(selectStatement) || this.hasAggregation(selectStatement) || this.hasDistinct(selectStatement) || this.hasLimit(selectStatement);
    }

    private boolean hasGroupBy(SelectStatement selectStatement) {
        return selectStatement.getGroupBy().map(groupBySegment -> !groupBySegment.getGroupByItems().isEmpty()).orElse(false);
    }

    private boolean hasAggregation(SelectStatement selectStatement) {
        for (ProjectionSegment each : selectStatement.getProjections().getProjections()) {
            if (!(each instanceof AggregationProjectionSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDistinct(SelectStatement selectStatement) {
        return selectStatement.getProjections().isDistinctRow();
    }

    private boolean hasLimit(SelectStatement selectStatement) {
        return SelectStatementHandler.getLimitSegment((SelectStatement)selectStatement).isPresent();
    }

    @Generated
    public ShardingCreateViewStatementValidator(RuleMetaData globalRuleMetaData) {
        this.globalRuleMetaData = globalRuleMetaData;
    }
}

