/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateProcedureStatementHandler;

public final class ShardingCreateProcedureStatementValidator
extends ShardingDDLStatementValidator {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        CreateProcedureStatement createProcedureStatement = (CreateProcedureStatement)sqlStatementContext.getSqlStatement();
        Optional routineBodySegment = CreateProcedureStatementHandler.getRoutineBodySegment((CreateProcedureStatement)createProcedureStatement);
        if (!routineBodySegment.isPresent()) {
            return;
        }
        TableExtractor extractor = new TableExtractor();
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        ShardingSphereSchema schema = createProcedureStatement.getProcedureName().flatMap(optional -> optional.getOwner().map(owner -> database.getSchema(owner.getIdentifier().getValue()))).orElseGet(() -> database.getSchema(defaultSchemaName));
        Collection existTables = extractor.extractExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get());
        this.validateShardingTable(shardingRule, "CREATE PROCEDURE", existTables);
        this.validateTableExist(schema, existTables);
        Collection notExistTables = extractor.extractNotExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get());
        this.validateTableNotExist(schema, notExistTables);
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
    }
}

