/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateFunctionStatementHandler;

public final class ShardingCreateFunctionStatementValidator
extends ShardingDDLStatementValidator {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        CreateFunctionStatement createFunctionStatement = (CreateFunctionStatement)sqlStatementContext.getSqlStatement();
        Optional routineBodySegment = CreateFunctionStatementHandler.getRoutineBodySegment((CreateFunctionStatement)createFunctionStatement);
        if (!routineBodySegment.isPresent()) {
            return;
        }
        TableExtractor extractor = new TableExtractor();
        Collection existTables = extractor.extractExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get());
        this.validateShardingTable(shardingRule, "CREATE FUNCTION", existTables);
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        ShardingSphereSchema schema = createFunctionStatement.getFunctionName().flatMap(optional -> optional.getOwner().map(owner -> database.getSchema(owner.getIdentifier().getValue()))).orElseGet(() -> database.getSchema(defaultSchemaName));
        this.validateTableExist(schema, existTables);
        this.validateTableNotExist(schema, extractor.extractNotExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get()));
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
    }
}

