/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.syntax.RenamedViewWithoutSameConfigurationException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterViewStatementHandler;

public final class ShardingAlterViewStatementValidator
extends ShardingDDLStatementValidator {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        Optional renamedView;
        AlterViewStatement alterViewStatement = (AlterViewStatement)sqlStatementContext.getSqlStatement();
        Optional selectStatement = AlterViewStatementHandler.getSelectStatement((AlterViewStatement)alterViewStatement);
        if (selectStatement.isPresent()) {
            TableExtractor extractor = new TableExtractor();
            extractor.extractTablesFromSelect((SelectStatement)selectStatement.get());
            this.validateShardingTable(shardingRule, "ALTER VIEW", extractor.getRewriteTables());
        }
        if ((renamedView = AlterViewStatementHandler.getRenameView((AlterViewStatement)alterViewStatement)).isPresent()) {
            String targetView = ((SimpleTableSegment)renamedView.get()).getTableName().getIdentifier().getValue();
            String originView = alterViewStatement.getView().getTableName().getIdentifier().getValue();
            this.validateBroadcastShardingView(shardingRule, originView, targetView);
        }
    }

    private void validateBroadcastShardingView(ShardingRule shardingRule, String originView, String targetView) {
        ShardingSpherePreconditions.checkState((!shardingRule.isShardingTable(originView) && !shardingRule.isShardingTable(targetView) || shardingRule.isAllBindingTables(Arrays.asList(originView, targetView)) ? 1 : 0) != 0, () -> new RenamedViewWithoutSameConfigurationException(originView, targetView));
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
    }
}

