/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl;

import java.util.Collection;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public abstract class ShardingDDLStatementValidator
implements ShardingStatementValidator {
    protected void validateShardingTable(ShardingRule shardingRule, String operation, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (!shardingRule.isShardingTable(tableName)) continue;
            throw new UnsupportedShardingOperationException(operation, tableName);
        }
    }

    protected void validateTableExist(ShardingSphereSchema schema, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (schema.containsTable(tableName)) continue;
            throw new NoSuchTableException(tableName);
        }
    }

    protected void validateTableNotExist(ShardingSphereSchema schema, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (!schema.containsTable(tableName)) continue;
            throw new TableExistsException(tableName);
        }
    }

    protected boolean isRouteUnitDataNodeDifferentSize(ShardingRule shardingRule, RouteContext routeContext, String tableName) {
        return shardingRule.isShardingTable(tableName) && shardingRule.getShardingTable(tableName).getActualDataNodes().size() != routeContext.getRouteUnits().size();
    }

    protected boolean isSchemaContainsIndex(ShardingSphereSchema schema, IndexSegment index) {
        return schema.getAllTableNames().stream().anyMatch(each -> schema.getTable(each).containsIndex(index.getIndexName().getIdentifier().getValue()));
    }
}

