/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.TokenUtils;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class TableToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue tableName;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule shardingRule;

    public TableToken(int startIndex, int stopIndex, IdentifierValue tableSegment, SQLStatementContext sqlStatementContext, ShardingRule shardingRule) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.tableName = tableSegment;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
    }

    public String toString(RouteUnit routeUnit) {
        String actualTableName = TokenUtils.getLogicAndActualTableMap(routeUnit, this.sqlStatementContext, this.shardingRule).get(this.tableName.getValue().toLowerCase());
        actualTableName = null == actualTableName ? this.tableName.getValue() : actualTableName;
        return this.tableName.getQuoteCharacter().wrap(actualTableName);
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

