/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ProjectionsToken;
import org.apache.shardingsphere.sql.parser.sql.common.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ProjectionsTokenGenerator
implements OptionalSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute,
RouteContextAware {
    private RouteContext routeContext;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !this.getDerivedProjectionTexts((SelectStatementContext)sqlStatementContext).isEmpty();
    }

    public ProjectionsToken generateSQLToken(SelectStatementContext selectStatementContext) {
        Map<RouteUnit, Collection<String>> derivedProjectionTexts = this.getDerivedProjectionTexts(selectStatementContext);
        return new ProjectionsToken(selectStatementContext.getProjectionsContext().getStopIndex() + 1 + " ".length(), derivedProjectionTexts);
    }

    private Map<RouteUnit, Collection<String>> getDerivedProjectionTexts(SelectStatementContext selectStatementContext) {
        HashMap<RouteUnit, Collection<String>> result = new HashMap<RouteUnit, Collection<String>>();
        for (RouteUnit routeUnit : this.routeContext.getRouteUnits()) {
            Collection<String> projectionTexts = this.getDerivedProjectionTextsByRouteUnit(selectStatementContext, routeUnit);
            if (projectionTexts.isEmpty()) continue;
            result.put(routeUnit, projectionTexts);
        }
        return result;
    }

    private Collection<String> getDerivedProjectionTextsByRouteUnit(SelectStatementContext selectStatementContext, RouteUnit routeUnit) {
        LinkedList<String> result = new LinkedList<String>();
        for (Projection each : selectStatementContext.getProjectionsContext().getProjections()) {
            if (each instanceof AggregationProjection && !((AggregationProjection)each).getDerivedAggregationProjections().isEmpty()) {
                result.addAll(((AggregationProjection)each).getDerivedAggregationProjections().stream().map(this::getDerivedProjectionText).collect(Collectors.toList()));
                continue;
            }
            if (each instanceof DerivedProjection && ((DerivedProjection)each).getDerivedProjectionSegment() instanceof ColumnOrderByItemSegment) {
                TableExtractor tableExtractor = new TableExtractor();
                tableExtractor.extractTablesFromSelect(selectStatementContext.getSqlStatement());
                result.add(this.getDerivedProjectionTextFromColumnOrderByItemSegment((DerivedProjection)each, tableExtractor, routeUnit, selectStatementContext.getDatabaseType()));
                continue;
            }
            if (!(each instanceof DerivedProjection)) continue;
            result.add(this.getDerivedProjectionText(each));
        }
        return result;
    }

    private String getDerivedProjectionText(Projection projection) {
        Preconditions.checkState((boolean)projection.getAlias().isPresent());
        if (projection instanceof AggregationDistinctProjection) {
            return ((AggregationDistinctProjection)projection).getDistinctInnerExpression() + " AS " + ((IdentifierValue)projection.getAlias().get()).getValue() + " ";
        }
        return projection.getExpression() + " AS " + ((IdentifierValue)projection.getAlias().get()).getValue() + " ";
    }

    private String getDerivedProjectionTextFromColumnOrderByItemSegment(DerivedProjection projection, TableExtractor tableExtractor, RouteUnit routeUnit, DatabaseType databaseType) {
        Preconditions.checkState((boolean)projection.getAlias().isPresent());
        Preconditions.checkState((boolean)(projection.getDerivedProjectionSegment() instanceof ColumnOrderByItemSegment));
        ColumnOrderByItemSegment columnOrderByItemSegment = (ColumnOrderByItemSegment)projection.getDerivedProjectionSegment();
        ColumnOrderByItemSegment newColumnOrderByItem = this.generateNewColumnOrderByItem(columnOrderByItemSegment, routeUnit, tableExtractor, databaseType);
        return newColumnOrderByItem.getText() + " AS " + ((IdentifierValue)projection.getAlias().get()).getValue() + " ";
    }

    private Optional<String> getActualTables(RouteUnit routeUnit, String logicalTableName) {
        for (RouteMapper each : routeUnit.getTableMappers()) {
            if (!each.getLogicName().equalsIgnoreCase(logicalTableName)) continue;
            return Optional.of(each.getActualName());
        }
        return Optional.empty();
    }

    private ColumnOrderByItemSegment generateNewColumnOrderByItem(ColumnOrderByItemSegment old, RouteUnit routeUnit, TableExtractor tableExtractor, DatabaseType databaseType) {
        Optional ownerSegment = old.getColumn().getOwner();
        if (!ownerSegment.isPresent()) {
            return old;
        }
        if (!tableExtractor.needRewrite((OwnerSegment)ownerSegment.get())) {
            return old;
        }
        Optional<String> actualTableName = this.getActualTables(routeUnit, ((OwnerSegment)ownerSegment.get()).getIdentifier().getValue());
        Preconditions.checkState((boolean)actualTableName.isPresent());
        ColumnSegment newColumnSegment = new ColumnSegment(0, 0, old.getColumn().getIdentifier());
        IdentifierValue newOwnerIdentifier = new IdentifierValue(((OwnerSegment)ownerSegment.get()).getIdentifier().getQuoteCharacter().wrap(actualTableName.get()));
        OwnerSegment newOwner = new OwnerSegment(0, 0, newOwnerIdentifier);
        newColumnSegment.setOwner(newOwner);
        return new ColumnOrderByItemSegment(newColumnSegment, old.getOrderDirection(), this.generateNewNullsOrderType(old.getOrderDirection(), databaseType));
    }

    private NullsOrderType generateNewNullsOrderType(OrderDirection orderDirection, DatabaseType databaseType) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return OrderDirection.ASC == orderDirection ? dialectDatabaseMetaData.getDefaultNullsOrderType() : dialectDatabaseMetaData.getDefaultNullsOrderType().getReversedOrderType();
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

