/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ConstraintToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ConstraintTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
ShardingRuleAware {
    private ShardingRule shardingRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof ConstraintAvailable && !((ConstraintAvailable)sqlStatementContext).getConstraints().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        if (sqlStatementContext instanceof ConstraintAvailable) {
            for (ConstraintSegment each : ((ConstraintAvailable)sqlStatementContext).getConstraints()) {
                IdentifierValue constraintIdentifier = each.getIdentifier();
                if (null == constraintIdentifier) continue;
                result.add(new ConstraintToken(each.getStartIndex(), each.getStopIndex(), constraintIdentifier, sqlStatementContext, this.shardingRule));
            }
        }
        return result;
    }

    @Override
    @Generated
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

