/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.AggregationDistinctToken;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class AggregationDistinctTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext;
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (AggregationDistinctProjection each : ((SelectStatementContext)sqlStatementContext).getProjectionsContext().getAggregationDistinctProjections()) {
            result.add(this.generateSQLToken(each));
        }
        return result;
    }

    private AggregationDistinctToken generateSQLToken(AggregationDistinctProjection projection) {
        Preconditions.checkArgument((boolean)projection.getAlias().isPresent());
        String derivedAlias = DerivedColumn.isDerivedColumnName((String)((IdentifierValue)projection.getAlias().get()).getValue()) ? ((IdentifierValue)projection.getAlias().get()).getValue() : null;
        return new AggregationDistinctToken(projection.getStartIndex(), projection.getStopIndex(), projection.getDistinctInnerExpression(), derivedAlias);
    }
}

