/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.orderby;

import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.OrderDirection;

public final class CompareUtils {
    public static int compareTo(Comparable thisValue, Comparable otherValue, OrderDirection orderDirection, NullsOrderType nullsOrderType, boolean caseSensitive) {
        if (null == thisValue && null == otherValue) {
            return 0;
        }
        if (null == thisValue) {
            return NullsOrderType.FIRST == nullsOrderType ? -1 : 1;
        }
        if (null == otherValue) {
            return NullsOrderType.FIRST == nullsOrderType ? 1 : -1;
        }
        if (!caseSensitive && thisValue instanceof String && otherValue instanceof String) {
            return CompareUtils.compareToCaseInsensitiveString((String)((Object)thisValue), (String)((Object)otherValue), orderDirection);
        }
        return OrderDirection.ASC == orderDirection ? thisValue.compareTo(otherValue) : -thisValue.compareTo(otherValue);
    }

    private static int compareToCaseInsensitiveString(String thisValue, String otherValue, OrderDirection orderDirection) {
        int result = thisValue.toUpperCase().compareTo(otherValue.toUpperCase());
        return OrderDirection.ASC == orderDirection ? result : -result;
    }

    @Generated
    private CompareUtils() {
    }
}

