/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.sharding.merge.dal.show.LogicTablesMergedResult;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShowCreateTableMergedResult
extends LogicTablesMergedResult {
    public ShowCreateTableMergedResult(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super(shardingRule, sqlStatementContext, schema, queryResults);
    }

    @Override
    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, ShardingSphereTable table, ShardingRule shardingRule) {
        String actualIndexName;
        memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replaceFirst(actualTableName, logicTableName));
        for (ShardingSphereIndex each : table.getIndexValues()) {
            actualIndexName = IndexMetaDataUtils.getActualIndexName((String)each.getName(), (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, each.getName()));
        }
        for (ShardingSphereIndex each : table.getConstraintValues()) {
            actualIndexName = IndexMetaDataUtils.getActualIndexName((String)each.getName(), (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, each.getName()));
            Optional<ShardingTable> shardingTable = shardingRule.findShardingTable(each.getReferencedTableName());
            if (!shardingTable.isPresent()) continue;
            for (DataNode dataNode : shardingTable.get().getActualDataNodes()) {
                memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(dataNode.getTableName(), each.getReferencedTableName()));
            }
        }
    }
}

