/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.decider;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationDecider;

public final class ShardingSQLFederationDecider
implements SQLFederationDecider<ShardingRule> {
    public boolean decide(SelectStatementContext selectStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule, Collection<DataNode> includedDataNodes) {
        Collection<String> tableNames = rule.getShardingLogicTableNames(selectStatementContext.getTablesContext().getTableNames());
        if (tableNames.isEmpty()) {
            return false;
        }
        includedDataNodes.addAll(this.getTableDataNodes(rule, tableNames));
        ShardingConditions shardingConditions = this.getMergedShardingConditions((SQLStatementContext)selectStatementContext, parameters, globalRuleMetaData, database, rule);
        if (shardingConditions.isNeedMerge() && shardingConditions.isSameShardingCondition()) {
            return false;
        }
        if (selectStatementContext.isContainsSubquery() || selectStatementContext.isContainsHaving() || selectStatementContext.isContainsCombine() || selectStatementContext.isContainsPartialDistinctAggregation()) {
            return true;
        }
        if (!selectStatementContext.isContainsJoinQuery() || rule.isAllTablesInSameDataSource(tableNames)) {
            return false;
        }
        return tableNames.size() > 1 && !rule.isAllBindingTables(database, (SQLStatementContext)selectStatementContext, tableNames);
    }

    private Collection<DataNode> getTableDataNodes(ShardingRule rule, Collection<String> tableNames) {
        HashSet<DataNode> result = new HashSet<DataNode>();
        for (String each : tableNames) {
            rule.findShardingTable(each).ifPresent(optional -> result.addAll(optional.getActualDataNodes()));
        }
        return result;
    }

    private ShardingConditions getMergedShardingConditions(SQLStatementContext sqlStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule) {
        List<ShardingCondition> shardingConditions = new ShardingConditionEngine(globalRuleMetaData, database, rule).createShardingConditions(sqlStatementContext, parameters);
        ShardingConditions result = new ShardingConditions(shardingConditions, sqlStatementContext, rule);
        if (result.isNeedMerge()) {
            result.merge();
        }
        return result;
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

