/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.auditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditor;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingSQLAuditor
implements SQLAuditor<ShardingRule> {
    public void audit(SQLStatementContext sqlStatementContext, List<Object> params, Grantee grantee, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule, HintValueContext hintValueContext) {
        Collection<ShardingAuditStrategyConfiguration> auditStrategies = this.getShardingAuditStrategies(sqlStatementContext, rule);
        if (auditStrategies.isEmpty()) {
            return;
        }
        Collection disableAuditNames = hintValueContext.getDisableAuditNames();
        for (ShardingAuditStrategyConfiguration auditStrategy : auditStrategies) {
            for (String auditorName : auditStrategy.getAuditorNames()) {
                if (auditStrategy.isAllowHintDisable() && disableAuditNames.contains(auditorName.toLowerCase())) continue;
                rule.getAuditors().get(auditorName).check(sqlStatementContext, params, grantee, globalRuleMetaData, database);
            }
        }
    }

    private Collection<ShardingAuditStrategyConfiguration> getShardingAuditStrategies(SQLStatementContext sqlStatementContext, ShardingRule rule) {
        Collection tableNames = sqlStatementContext.getTablesContext().getTableNames();
        ArrayList<ShardingAuditStrategyConfiguration> result = new ArrayList<ShardingAuditStrategyConfiguration>(tableNames.size());
        for (String each : tableNames) {
            rule.findShardingTable(each).ifPresent(optional -> result.add(rule.getAuditStrategyConfiguration((ShardingTable)optional)));
        }
        return result;
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

