/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.mod;

import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.algorithm.sharding.ShardingAutoTableAlgorithmUtils;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;
import org.apache.shardingsphere.sharding.exception.data.ShardingValueOffsetException;

public final class ModShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String SHARDING_COUNT_KEY = "sharding-count";
    private static final String START_OFFSET_INDEX_KEY = "start-offset";
    private static final String STOP_OFFSET_INDEX_KEY = "stop-offset";
    private static final String ZERO_PADDING_KEY = "zero-padding";
    private int shardingCount;
    private int startOffset;
    private int stopOffset;
    private boolean zeroPadding;
    private int maxPaddingSize;

    public void init(Properties props) {
        this.shardingCount = this.getShardingCount(props);
        this.startOffset = this.getStartOffset(props);
        this.stopOffset = this.getStopOffset(props);
        this.zeroPadding = this.isZeroPadding(props);
        this.maxPaddingSize = this.calculateMaxPaddingSize();
    }

    private int getShardingCount(Properties props) {
        ShardingSpherePreconditions.checkState((boolean)props.containsKey(SHARDING_COUNT_KEY), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Sharding count can not be null.", new Object[0]));
        int result = Integer.parseInt(String.valueOf(props.getProperty(SHARDING_COUNT_KEY)));
        ShardingSpherePreconditions.checkState((result > 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Sharding count must be a positive integer.", new Object[0]));
        return result;
    }

    private int getStartOffset(Properties props) {
        int result = Integer.parseInt(String.valueOf(props.getProperty(START_OFFSET_INDEX_KEY, "0")));
        ShardingSpherePreconditions.checkState((result >= 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Start offset can not be less than 0.", new Object[0]));
        return result;
    }

    private int getStopOffset(Properties props) {
        int result = Integer.parseInt(String.valueOf(props.getProperty(STOP_OFFSET_INDEX_KEY, "0")));
        ShardingSpherePreconditions.checkState((result >= 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Stop offset can not be less than 0.", new Object[0]));
        return result;
    }

    private boolean isZeroPadding(Properties props) {
        return Boolean.parseBoolean(String.valueOf(props.getProperty(ZERO_PADDING_KEY, Boolean.FALSE.toString())));
    }

    private int calculateMaxPaddingSize() {
        int result = 0;
        for (int calculatingShardingCount = this.shardingCount - 1; 0 != calculatingShardingCount; calculatingShardingCount /= 10) {
            ++result;
        }
        return Math.max(result, 1);
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        ShardingSpherePreconditions.checkNotNull((Object)shardingValue.getValue(), NullShardingValueException::new);
        String shardingResultSuffix = this.getShardingResultSuffix(this.cutShardingValue((Comparable)shardingValue.getValue()).mod(new BigInteger(String.valueOf(this.shardingCount))).toString());
        return ShardingAutoTableAlgorithmUtils.findMatchedTargetName(availableTargetNames, shardingResultSuffix, shardingValue.getDataNodeInfo()).orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.containsAllTargets(shardingValue) ? availableTargetNames : this.getAvailableTargetNames(availableTargetNames, shardingValue);
    }

    private boolean containsAllTargets(RangeShardingValue<Comparable<?>> shardingValue) {
        return !shardingValue.getValueRange().hasUpperBound() || shardingValue.getValueRange().hasLowerBound() && this.getBigInteger(shardingValue.getValueRange().upperEndpoint()).subtract(this.getBigInteger(shardingValue.getValueRange().lowerEndpoint())).intValue() >= this.shardingCount - 1;
    }

    private Collection<String> getAvailableTargetNames(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size(), 1.0f);
        BigInteger lower = new BigInteger(shardingValue.getValueRange().lowerEndpoint().toString());
        BigInteger upper = new BigInteger(shardingValue.getValueRange().upperEndpoint().toString());
        BigInteger shardingCountBigInter = new BigInteger(String.valueOf(this.shardingCount));
        BigInteger i = lower;
        while (i.compareTo(upper) <= 0) {
            String shardingResultSuffix = this.getShardingResultSuffix(String.valueOf(i.mod(shardingCountBigInter)));
            ShardingAutoTableAlgorithmUtils.findMatchedTargetName(availableTargetNames, shardingResultSuffix, shardingValue.getDataNodeInfo()).ifPresent(result::add);
            i = i.add(BigInteger.ONE);
        }
        return result;
    }

    private String getShardingResultSuffix(String shardingResultSuffix) {
        return this.zeroPadding ? this.fillZero(shardingResultSuffix) : shardingResultSuffix;
    }

    private String fillZero(String value) {
        return String.format("%0" + this.maxPaddingSize + "d", Integer.parseInt(value));
    }

    private BigInteger cutShardingValue(Comparable<?> shardingValue) {
        ShardingSpherePreconditions.checkState((shardingValue.toString().length() - this.stopOffset > this.startOffset ? 1 : 0) != 0, () -> new ShardingValueOffsetException(shardingValue, this.startOffset, this.stopOffset));
        return 0 == this.startOffset && 0 == this.stopOffset ? this.getBigInteger(shardingValue) : new BigInteger(shardingValue.toString().substring(this.startOffset, shardingValue.toString().length() - this.stopOffset));
    }

    private BigInteger getBigInteger(Comparable<?> value) {
        return value instanceof Number ? BigInteger.valueOf(((Number)((Object)value)).longValue()) : new BigInteger(value.toString());
    }

    public int getAutoTablesAmount() {
        return this.shardingCount;
    }

    public String getType() {
        return "MOD";
    }
}

