/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.mod;

import java.util.Collection;
import java.util.Properties;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.algorithm.sharding.ShardingAutoTableAlgorithmUtils;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;

public final class HashModShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String SHARDING_COUNT_KEY = "sharding-count";
    private int shardingCount;

    public void init(Properties props) {
        this.shardingCount = this.getShardingCount(props);
    }

    private int getShardingCount(Properties props) {
        ShardingSpherePreconditions.checkState((boolean)props.containsKey(SHARDING_COUNT_KEY), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Sharding count cannot be null.", new Object[0]));
        int result = Integer.parseInt(String.valueOf(props.getProperty(SHARDING_COUNT_KEY)));
        ShardingSpherePreconditions.checkState((result > 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Sharding count must be a positive integer.", new Object[0]));
        return result;
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        ShardingSpherePreconditions.checkNotNull((Object)shardingValue.getValue(), NullShardingValueException::new);
        String suffix = String.valueOf(this.hashShardingValue(shardingValue.getValue()) % (long)this.shardingCount);
        return ShardingAutoTableAlgorithmUtils.findMatchedTargetName(availableTargetNames, suffix, shardingValue.getDataNodeInfo()).orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return availableTargetNames;
    }

    private long hashShardingValue(Object shardingValue) {
        return Math.abs((long)shardingValue.hashCode());
    }

    public int getAutoTablesAmount() {
        return this.shardingCount;
    }

    public String getType() {
        return "HASH_MOD";
    }
}

