/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.inline;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.expr.core.InlineExpressionParserFactory;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingValue;
import org.apache.shardingsphere.sharding.exception.algorithm.MismatchedComplexInlineShardingAlgorithmColumnAndValueSizeException;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;

public final class ComplexInlineShardingAlgorithm
implements ComplexKeysShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String SHARING_COLUMNS_KEY = "sharding-columns";
    private static final String ALLOW_RANGE_QUERY_KEY = "allow-range-query-with-inline-sharding";
    private String algorithmExpression;
    private Collection<String> shardingColumns;
    private boolean allowRangeQuery;

    public void init(Properties props) {
        this.algorithmExpression = this.getAlgorithmExpression(props);
        this.shardingColumns = this.getShardingColumns(props);
        this.allowRangeQuery = this.getAllowRangeQuery(props);
    }

    private String getAlgorithmExpression(Properties props) {
        String algorithmExpression = props.getProperty(ALGORITHM_EXPRESSION_KEY);
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)algorithmExpression) ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Inline sharding algorithm expression can not be null.", new Object[0]));
        return InlineExpressionParserFactory.newInstance((String)algorithmExpression.trim()).handlePlaceHolder();
    }

    private Collection<String> getShardingColumns(Properties props) {
        String shardingColumns = props.getProperty(SHARING_COLUMNS_KEY, "");
        return shardingColumns.isEmpty() ? Collections.emptyList() : Arrays.asList(shardingColumns.split(","));
    }

    private boolean getAllowRangeQuery(Properties props) {
        return Boolean.parseBoolean(props.getOrDefault((Object)ALLOW_RANGE_QUERY_KEY, Boolean.FALSE.toString()).toString());
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, ComplexKeysShardingValue<Comparable<?>> shardingValue) {
        if (!shardingValue.getColumnNameAndRangeValuesMap().isEmpty()) {
            ShardingSpherePreconditions.checkState((boolean)this.allowRangeQuery, () -> new UnsupportedSQLOperationException(String.format("Since the property of `%s` is false, inline sharding algorithm can not tackle with range query", ALLOW_RANGE_QUERY_KEY)));
            return availableTargetNames;
        }
        Map columnNameAndShardingValuesMap = shardingValue.getColumnNameAndShardingValuesMap();
        ShardingSpherePreconditions.checkState((this.shardingColumns.isEmpty() || this.shardingColumns.size() == columnNameAndShardingValuesMap.size() ? 1 : 0) != 0, () -> new MismatchedComplexInlineShardingAlgorithmColumnAndValueSizeException(this.shardingColumns.size(), columnNameAndShardingValuesMap.size()));
        return this.flatten(columnNameAndShardingValuesMap).stream().map(this::doSharding).collect(Collectors.toList());
    }

    private String doSharding(Map<String, Comparable<?>> columnNameAndShardingValueMap) {
        columnNameAndShardingValueMap.forEach((key, value) -> ShardingSpherePreconditions.checkNotNull((Object)value, NullShardingValueException::new));
        return InlineExpressionParserFactory.newInstance((String)this.algorithmExpression).evaluateWithArgs(columnNameAndShardingValueMap);
    }

    private Collection<Map<String, Comparable<?>>> flatten(Map<String, Collection<Comparable<?>>> columnNameAndShardingValuesMap) {
        Collection<Map<String, Comparable<?>>> result = new LinkedList();
        for (Map.Entry<String, Collection<Comparable<?>>> entry : columnNameAndShardingValuesMap.entrySet()) {
            if (result.isEmpty()) {
                for (Comparable<?> value : entry.getValue()) {
                    HashMap item = new HashMap();
                    item.put(entry.getKey(), value);
                    result.add(item);
                }
                continue;
            }
            result = this.flatten(result, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Collection<Map<String, Comparable<?>>> flatten(Collection<Map<String, Comparable<?>>> columnNameAndShardingValueMaps, String columnName, Collection<Comparable<?>> shardingValues) {
        LinkedList result = new LinkedList();
        for (Map<String, Comparable<?>> each : columnNameAndShardingValueMaps) {
            for (Comparable<?> value : shardingValues) {
                HashMap item = new HashMap();
                item.put(columnName, value);
                item.putAll(each);
                result.add(item);
            }
        }
        return result;
    }

    public String getType() {
        return "COMPLEX_INLINE";
    }
}

