/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.hint;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.core.InlineExpressionParserFactory;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingValue;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;

public final class HintInlineShardingAlgorithm
implements HintShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String DEFAULT_ALGORITHM_EXPRESSION = "${value}";
    private static final String HINT_INLINE_VALUE_PROPERTY_NAME = "value";
    private String algorithmExpression;

    public void init(Properties props) {
        this.algorithmExpression = this.getAlgorithmExpression(props);
    }

    private String getAlgorithmExpression(Properties props) {
        String algorithmExpression = props.getProperty(ALGORITHM_EXPRESSION_KEY, DEFAULT_ALGORITHM_EXPRESSION);
        ShardingSpherePreconditions.checkNotNull((Object)algorithmExpression, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Inline sharding algorithm expression can not be null.", new Object[0]));
        return InlineExpressionParserFactory.newInstance((String)algorithmExpression.trim()).handlePlaceHolder();
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, HintShardingValue<Comparable<?>> shardingValue) {
        return shardingValue.getValues().isEmpty() ? availableTargetNames : (Collection)shardingValue.getValues().stream().map(this::doSharding).collect(Collectors.toList());
    }

    private String doSharding(Comparable<?> shardingValue) {
        ShardingSpherePreconditions.checkNotNull(shardingValue, NullShardingValueException::new);
        LinkedHashMap map = new LinkedHashMap();
        map.put(HINT_INLINE_VALUE_PROPERTY_NAME, shardingValue);
        return InlineExpressionParserFactory.newInstance((String)this.algorithmExpression).evaluateWithArgs(map);
    }

    public String getType() {
        return "HINT_INLINE";
    }
}

