/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime;

import com.google.common.base.Strings;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.data.InvalidDatetimeFormatException;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;

public final class IntervalShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>> {
    private static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    private static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    private static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    private static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    private static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    private static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    private String dateTimePatternString;
    private DateTimeFormatter dateTimeFormatter;
    private int dateTimePatternLength;
    private TemporalAccessor dateTimeLower;
    private TemporalAccessor dateTimeUpper;
    private DateTimeFormatter tableSuffixPattern;
    private int stepAmount;
    private ChronoUnit stepUnit;

    public void init(Properties props) {
        this.dateTimePatternString = this.getDateTimePattern(props);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateTimePatternString);
        this.dateTimePatternLength = this.dateTimePatternString.length();
        this.dateTimeLower = this.getDateTimeLower(props, this.dateTimePatternString);
        this.dateTimeUpper = this.getDateTimeUpper(props, this.dateTimePatternString);
        this.tableSuffixPattern = this.getTableSuffixPattern(props);
        this.stepAmount = Integer.parseInt(props.getOrDefault((Object)INTERVAL_AMOUNT_KEY, (Object)1).toString());
        this.stepUnit = props.containsKey(INTERVAL_UNIT_KEY) ? this.getStepUnit(props.getProperty(INTERVAL_UNIT_KEY)) : ChronoUnit.DAYS;
    }

    private String getDateTimePattern(Properties props) {
        ShardingSpherePreconditions.checkState((boolean)props.containsKey(DATE_TIME_PATTERN_KEY), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s can not be null", DATE_TIME_PATTERN_KEY), new Object[0]));
        return props.getProperty(DATE_TIME_PATTERN_KEY);
    }

    private TemporalAccessor getDateTimeLower(Properties props, String dateTimePattern) {
        ShardingSpherePreconditions.checkState((boolean)props.containsKey(DATE_TIME_LOWER_KEY), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s can not be null.", DATE_TIME_LOWER_KEY), new Object[0]));
        return this.getDateTime(DATE_TIME_LOWER_KEY, props.getProperty(DATE_TIME_LOWER_KEY), dateTimePattern);
    }

    private TemporalAccessor getDateTimeUpper(Properties props, String dateTimePattern) {
        return props.containsKey(DATE_TIME_UPPER_KEY) ? this.getDateTime(DATE_TIME_UPPER_KEY, props.getProperty(DATE_TIME_UPPER_KEY), dateTimePattern) : LocalDateTime.now();
    }

    private TemporalAccessor getDateTime(String dateTimeKey, String dateTimeValue, String dateTimePattern) {
        try {
            return this.dateTimeFormatter.parse(dateTimeValue);
        }
        catch (DateTimeParseException ignored) {
            throw new InvalidDatetimeFormatException(dateTimeKey, dateTimeValue, dateTimePattern);
        }
    }

    private DateTimeFormatter getTableSuffixPattern(Properties props) {
        String suffix = props.getProperty(SHARDING_SUFFIX_FORMAT_KEY);
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)suffix) ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s can not be null or empty.", SHARDING_SUFFIX_FORMAT_KEY), new Object[0]));
        return DateTimeFormatter.ofPattern(suffix);
    }

    private ChronoUnit getStepUnit(String stepUnit) {
        for (ChronoUnit each : ChronoUnit.values()) {
            if (!each.toString().equalsIgnoreCase(stepUnit)) continue;
            return each;
        }
        throw new UnsupportedSQLOperationException(String.format("Cannot find step unit for specified %s property: `%s`", INTERVAL_UNIT_KEY, stepUnit));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        ShardingSpherePreconditions.checkNotNull((Object)shardingValue.getValue(), NullShardingValueException::new);
        return this.doSharding(availableTargetNames, Range.singleton((Comparable)((Comparable)shardingValue.getValue()))).stream().findFirst().orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.doSharding(availableTargetNames, shardingValue.getValueRange());
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, Range<Comparable<?>> range) {
        TemporalAccessor calculateTime = this.dateTimeLower;
        if (!calculateTime.isSupported(ChronoField.NANO_OF_DAY)) {
            if (calculateTime.isSupported(ChronoField.EPOCH_DAY)) {
                return this.doShardingInLocalDate(availableTargetNames, range, calculateTime);
            }
            if (calculateTime.isSupported(ChronoField.YEAR) && calculateTime.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return this.doShardingInYearMonth(availableTargetNames, range, calculateTime);
            }
            if (calculateTime.isSupported(ChronoField.YEAR)) {
                return this.doShardingInYear(availableTargetNames, range, calculateTime);
            }
            if (calculateTime.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return this.doShardingInMonth(availableTargetNames, range, calculateTime);
            }
        }
        if (!calculateTime.isSupported(ChronoField.EPOCH_DAY)) {
            return this.doShardingInLocalTime(availableTargetNames, range, calculateTime);
        }
        return this.doShardingInLocalDateTime(availableTargetNames, range, calculateTime);
    }

    private Collection<String> doShardingInLocalDateTime(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        LocalDateTime calculateTimeAsView = LocalDateTime.from(calculateTime);
        LocalDateTime dateTimeUpperAsLocalDateTime = LocalDateTime.from(this.dateTimeUpper);
        LocalDateTime dateTimeLowerAsLocalDateTime = LocalDateTime.from(this.dateTimeLower);
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsLocalDateTime)) {
            if (this.hasIntersection((Range<LocalDateTime>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsLocalDateTime, dateTimeUpperAsLocalDateTime)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private Collection<String> doShardingInLocalTime(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        LocalTime dateTimeUpperAsLocalTime = this.dateTimeUpper.query(TemporalQueries.localTime());
        LocalTime dateTimeLowerAsLocalTime = this.dateTimeLower.query(TemporalQueries.localTime());
        LocalTime calculateTimeAsView = calculateTime.query(TemporalQueries.localTime());
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsLocalTime)) {
            if (this.hasIntersection((Range<LocalTime>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsLocalTime, dateTimeUpperAsLocalTime)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private Collection<String> doShardingInLocalDate(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        LocalDate dateTimeUpperAsLocalDate = this.dateTimeUpper.query(TemporalQueries.localDate());
        LocalDate dateTimeLowerAsLocalDate = this.dateTimeLower.query(TemporalQueries.localDate());
        LocalDate calculateTimeAsView = calculateTime.query(TemporalQueries.localDate());
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsLocalDate)) {
            if (this.hasIntersection((Range<LocalDate>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsLocalDate, dateTimeUpperAsLocalDate)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private Collection<String> doShardingInYear(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        Year dateTimeUpperAsYear = this.dateTimeUpper.query(Year::from);
        Year dateTimeLowerAsYear = this.dateTimeLower.query(Year::from);
        Year calculateTimeAsView = calculateTime.query(Year::from);
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsYear)) {
            if (this.hasIntersection((Range<Year>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsYear, dateTimeUpperAsYear)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private Collection<String> doShardingInMonth(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        Month dateTimeUpperAsMonth = this.dateTimeUpper.query(Month::from);
        Month dateTimeLowerAsMonth = this.dateTimeLower.query(Month::from);
        Month calculateTimeAsView = calculateTime.query(Month::from);
        while (calculateTimeAsView.getValue() <= dateTimeUpperAsMonth.getValue() && calculateTimeAsView.getValue() + this.stepAmount <= Month.DECEMBER.getValue()) {
            if (this.hasIntersection((Range<Month>)Range.closedOpen((Comparable)((Object)calculateTimeAsView), (Comparable)((Object)calculateTimeAsView.plus(this.stepAmount))), range, dateTimeLowerAsMonth, dateTimeUpperAsMonth)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount);
        }
        return result;
    }

    private Collection<String> doShardingInYearMonth(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        YearMonth dateTimeUpperAsYearMonth = this.dateTimeUpper.query(YearMonth::from);
        YearMonth dateTimeLowerAsYearMonth = this.dateTimeLower.query(YearMonth::from);
        YearMonth calculateTimeAsView = calculateTime.query(YearMonth::from);
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsYearMonth)) {
            if (this.hasIntersection((Range<YearMonth>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsYearMonth, dateTimeUpperAsYearMonth)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private boolean hasIntersection(Range<LocalDateTime> calculateRange, Range<Comparable<?>> range, LocalDateTime dateTimeLower, LocalDateTime dateTimeUpper) {
        LocalDateTime lower = range.hasLowerBound() ? this.parseLocalDateTime(range.lowerEndpoint()) : dateTimeLower;
        LocalDateTime upper = range.hasUpperBound() ? this.parseLocalDateTime(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private boolean hasIntersection(Range<LocalDate> calculateRange, Range<Comparable<?>> range, LocalDate dateTimeLower, LocalDate dateTimeUpper) {
        LocalDate lower = range.hasLowerBound() ? this.parseLocalDate(range.lowerEndpoint()) : dateTimeLower;
        LocalDate upper = range.hasUpperBound() ? this.parseLocalDate(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private boolean hasIntersection(Range<LocalTime> calculateRange, Range<Comparable<?>> range, LocalTime dateTimeLower, LocalTime dateTimeUpper) {
        LocalTime lower = range.hasLowerBound() ? this.parseLocalTime(range.lowerEndpoint()) : dateTimeLower;
        LocalTime upper = range.hasUpperBound() ? this.parseLocalTime(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private boolean hasIntersection(Range<Year> calculateRange, Range<Comparable<?>> range, Year dateTimeLower, Year dateTimeUpper) {
        Year lower = range.hasLowerBound() ? this.parseYear(range.lowerEndpoint()) : dateTimeLower;
        Year upper = range.hasUpperBound() ? this.parseYear(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private boolean hasIntersection(Range<Month> calculateRange, Range<Comparable<?>> range, Month dateTimeLower, Month dateTimeUpper) {
        Month lower = range.hasLowerBound() ? this.parseMonth(range.lowerEndpoint()) : dateTimeLower;
        Month upper = range.hasUpperBound() ? this.parseMonth(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)((Object)lower), (BoundType)lowerBoundType, (Comparable)((Object)upper), (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private boolean hasIntersection(Range<YearMonth> calculateRange, Range<Comparable<?>> range, YearMonth dateTimeLower, YearMonth dateTimeUpper) {
        YearMonth lower = range.hasLowerBound() ? this.parseYearMonth(range.lowerEndpoint()) : dateTimeLower;
        YearMonth upper = range.hasUpperBound() ? this.parseYearMonth(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private LocalDateTime parseLocalDateTime(Comparable<?> endpoint) {
        String dateTimeText = this.getDateTimeText(endpoint);
        if (dateTimeText.length() >= this.dateTimePatternLength) {
            return LocalDateTime.parse(dateTimeText.substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
        }
        return LocalDateTime.parse(dateTimeText, this.createRelaxedDateTimeFormatter(dateTimeText));
    }

    private LocalDate parseLocalDate(Comparable<?> endpoint) {
        String dateTimeText = this.getDateTimeText(endpoint);
        if (dateTimeText.length() >= this.dateTimePatternLength) {
            return LocalDate.parse(dateTimeText.substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
        }
        return LocalDate.parse(dateTimeText, this.createRelaxedDateTimeFormatter(dateTimeText));
    }

    private LocalTime parseLocalTime(Comparable<?> endpoint) {
        String dateTimeText = this.getDateTimeText(endpoint);
        if (dateTimeText.length() >= this.dateTimePatternLength) {
            return LocalTime.parse(dateTimeText.substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
        }
        return LocalTime.parse(dateTimeText, this.createRelaxedDateTimeFormatter(dateTimeText));
    }

    private Year parseYear(Comparable<?> endpoint) {
        String dateTimeText = this.getDateTimeText(endpoint);
        if (dateTimeText.length() >= this.dateTimePatternLength) {
            return Year.parse(dateTimeText.substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
        }
        return Year.parse(dateTimeText, this.createRelaxedDateTimeFormatter(dateTimeText));
    }

    private YearMonth parseYearMonth(Comparable<?> endpoint) {
        String dateTimeText = this.getDateTimeText(endpoint);
        if (dateTimeText.length() >= this.dateTimePatternLength) {
            return YearMonth.parse(dateTimeText.substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
        }
        return YearMonth.parse(dateTimeText, this.createRelaxedDateTimeFormatter(dateTimeText));
    }

    private Month parseMonth(Comparable<?> endpoint) {
        return Month.of(Integer.parseInt(this.getDateTimeText(endpoint).substring(0, this.dateTimePatternLength)));
    }

    private DateTimeFormatter createRelaxedDateTimeFormatter(String dateTimeText) {
        String dateTimeFormatterString = this.dateTimePatternString.substring(0, dateTimeText.length());
        return DateTimeFormatter.ofPattern(dateTimeFormatterString);
    }

    private String getDateTimeText(Comparable<?> endpoint) {
        if (endpoint instanceof Instant) {
            return this.dateTimeFormatter.format(((Instant)endpoint).atZone(ZoneId.systemDefault()));
        }
        if (endpoint instanceof TemporalAccessor) {
            return this.dateTimeFormatter.format((TemporalAccessor)((Object)endpoint));
        }
        if (endpoint instanceof Date) {
            return this.dateTimeFormatter.format(((Date)endpoint).toLocalDate());
        }
        if (endpoint instanceof java.util.Date) {
            return this.dateTimeFormatter.format(((java.util.Date)endpoint).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        return endpoint.toString();
    }

    private Collection<String> getMatchedTables(TemporalAccessor dateTime, Collection<String> availableTargetNames) {
        if (!dateTime.isSupported(ChronoField.NANO_OF_DAY)) {
            if (dateTime.isSupported(ChronoField.EPOCH_DAY)) {
                String tableSuffix = this.tableSuffixPattern.format(dateTime.query(TemporalQueries.localDate()));
                return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
            }
            if (dateTime.isSupported(ChronoField.YEAR) && dateTime.isSupported(ChronoField.MONTH_OF_YEAR)) {
                String tableSuffix = this.tableSuffixPattern.format(dateTime.query(YearMonth::from));
                return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
            }
            if (dateTime.isSupported(ChronoField.YEAR)) {
                String tableSuffix = this.tableSuffixPattern.format(dateTime.query(Year::from));
                return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
            }
            if (dateTime.isSupported(ChronoField.MONTH_OF_YEAR)) {
                String tableSuffix = this.tableSuffixPattern.format(dateTime.query(Month::from));
                return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
            }
        }
        if (!dateTime.isSupported(ChronoField.EPOCH_DAY)) {
            String tableSuffix = dateTime.query(TemporalQueries.localTime()).format(this.tableSuffixPattern);
            return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
        }
        String tableSuffix = LocalDateTime.from(dateTime).format(this.tableSuffixPattern);
        return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
    }

    public String getType() {
        return "INTERVAL";
    }
}

