/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.yaml.swapper;

import java.util.Map;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.YamlShardingAutoTableRuleConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.YamlShardingTableRuleConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlKeyGenerateStrategyConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlShardingAuditStrategyConfigurationSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlShardingStrategyConfigurationSwapper;

public final class YamlShardingRuleAlgorithmProviderConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlShardingRuleConfiguration, AlgorithmProvidedShardingRuleConfiguration> {
    private final YamlShardingTableRuleConfigurationSwapper tableSwapper = new YamlShardingTableRuleConfigurationSwapper();
    private final YamlShardingStrategyConfigurationSwapper shardingStrategySwapper = new YamlShardingStrategyConfigurationSwapper();
    private final YamlKeyGenerateStrategyConfigurationSwapper keyGenerateStrategySwapper = new YamlKeyGenerateStrategyConfigurationSwapper();
    private final YamlShardingAuditStrategyConfigurationSwapper auditStrategySwapper = new YamlShardingAuditStrategyConfigurationSwapper();
    private final YamlShardingAutoTableRuleConfigurationSwapper autoTableYamlSwapper = new YamlShardingAutoTableRuleConfigurationSwapper();

    public YamlShardingRuleConfiguration swapToYamlConfiguration(AlgorithmProvidedShardingRuleConfiguration data) {
        YamlShardingRuleConfiguration result = new YamlShardingRuleConfiguration();
        data.getTables().forEach(each -> result.getTables().put(each.getLogicTable(), this.tableSwapper.swapToYamlConfiguration((ShardingTableRuleConfiguration)each)));
        data.getAutoTables().forEach(each -> result.getAutoTables().put(each.getLogicTable(), this.autoTableYamlSwapper.swapToYamlConfiguration((ShardingAutoTableRuleConfiguration)each)));
        result.getBindingTables().addAll(data.getBindingTableGroups());
        result.getBroadcastTables().addAll(data.getBroadcastTables());
        this.setYamlStrategies(data, result);
        this.setYamlAlgorithms(data, result);
        result.setDefaultShardingColumn(data.getDefaultShardingColumn());
        return result;
    }

    private void setYamlStrategies(AlgorithmProvidedShardingRuleConfiguration data, YamlShardingRuleConfiguration yamlConfig) {
        if (null != data.getDefaultDatabaseShardingStrategy()) {
            yamlConfig.setDefaultDatabaseStrategy(this.shardingStrategySwapper.swapToYamlConfiguration(data.getDefaultDatabaseShardingStrategy()));
        }
        if (null != data.getDefaultTableShardingStrategy()) {
            yamlConfig.setDefaultTableStrategy(this.shardingStrategySwapper.swapToYamlConfiguration(data.getDefaultTableShardingStrategy()));
        }
        if (null != data.getDefaultKeyGenerateStrategy()) {
            yamlConfig.setDefaultKeyGenerateStrategy(this.keyGenerateStrategySwapper.swapToYamlConfiguration(data.getDefaultKeyGenerateStrategy()));
        }
        if (null != data.getDefaultAuditStrategy()) {
            yamlConfig.setDefaultAuditStrategy(this.auditStrategySwapper.swapToYamlConfiguration(data.getDefaultAuditStrategy()));
        }
    }

    private void setYamlAlgorithms(AlgorithmProvidedShardingRuleConfiguration data, YamlShardingRuleConfiguration yamlConfig) {
        if (null != data.getShardingAlgorithms()) {
            data.getShardingAlgorithms().forEach((key, value) -> yamlConfig.getShardingAlgorithms().put((String)key, new YamlAlgorithmConfiguration(value.getType(), value.getProps())));
        }
        if (null != data.getKeyGenerators()) {
            data.getKeyGenerators().forEach((key, value) -> yamlConfig.getKeyGenerators().put((String)key, new YamlAlgorithmConfiguration(value.getType(), value.getProps())));
        }
        if (null != data.getAuditors()) {
            data.getAuditors().forEach((key, value) -> yamlConfig.getAuditors().put((String)key, new YamlAlgorithmConfiguration(value.getType(), value.getProps())));
        }
    }

    public AlgorithmProvidedShardingRuleConfiguration swapToObject(YamlShardingRuleConfiguration yamlConfig) {
        Object tableRuleConfig;
        AlgorithmProvidedShardingRuleConfiguration result = new AlgorithmProvidedShardingRuleConfiguration();
        for (Map.Entry<String, YamlTableRuleConfiguration> entry : yamlConfig.getTables().entrySet()) {
            tableRuleConfig = entry.getValue();
            ((YamlTableRuleConfiguration)tableRuleConfig).setLogicTable(entry.getKey());
            result.getTables().add(this.tableSwapper.swapToObject((YamlTableRuleConfiguration)tableRuleConfig));
        }
        for (Map.Entry<String, Object> entry : yamlConfig.getAutoTables().entrySet()) {
            tableRuleConfig = (YamlShardingAutoTableRuleConfiguration)entry.getValue();
            ((YamlShardingAutoTableRuleConfiguration)tableRuleConfig).setLogicTable(entry.getKey());
            result.getAutoTables().add(this.autoTableYamlSwapper.swapToObject((YamlShardingAutoTableRuleConfiguration)tableRuleConfig));
        }
        result.getBindingTableGroups().addAll(yamlConfig.getBindingTables());
        result.getBroadcastTables().addAll(yamlConfig.getBroadcastTables());
        this.setStrategies(yamlConfig, result);
        result.setDefaultShardingColumn(yamlConfig.getDefaultShardingColumn());
        return result;
    }

    private void setStrategies(YamlShardingRuleConfiguration yamlConfig, AlgorithmProvidedShardingRuleConfiguration ruleConfig) {
        if (null != yamlConfig.getDefaultDatabaseStrategy()) {
            ruleConfig.setDefaultDatabaseShardingStrategy(this.shardingStrategySwapper.swapToObject(yamlConfig.getDefaultDatabaseStrategy()));
        }
        if (null != yamlConfig.getDefaultTableStrategy()) {
            ruleConfig.setDefaultTableShardingStrategy(this.shardingStrategySwapper.swapToObject(yamlConfig.getDefaultTableStrategy()));
        }
        if (null != yamlConfig.getDefaultKeyGenerateStrategy()) {
            ruleConfig.setDefaultKeyGenerateStrategy(this.keyGenerateStrategySwapper.swapToObject(yamlConfig.getDefaultKeyGenerateStrategy()));
        }
        if (null != yamlConfig.getDefaultAuditStrategy()) {
            ruleConfig.setDefaultAuditStrategy(this.auditStrategySwapper.swapToObject(yamlConfig.getDefaultAuditStrategy()));
        }
    }

    public Class<AlgorithmProvidedShardingRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedShardingRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHARDING";
    }

    public int getOrder() {
        return -9;
    }
}

