/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.strategy.type.complex;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.datanode.DataNodeInfo;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategy;

public final class ComplexShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final ComplexKeysShardingAlgorithm<?> shardingAlgorithm;

    public ComplexShardingStrategy(String shardingColumns, ComplexKeysShardingAlgorithm<?> shardingAlgorithm) {
        Preconditions.checkNotNull((Object)shardingColumns, (Object)"Sharding columns cannot be null.");
        Preconditions.checkNotNull(shardingAlgorithm, (Object)"Sharding algorithm cannot be null.");
        this.shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.shardingColumns.addAll(Splitter.on((String)",").trimResults().splitToList((CharSequence)shardingColumns));
        this.shardingAlgorithm = shardingAlgorithm;
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingConditionValue> shardingConditionValues, DataNodeInfo dataNodeInfo, ConfigurationProperties props) {
        HashMap columnShardingValues = new HashMap(shardingConditionValues.size(), 1.0f);
        HashMap columnRangeValues = new HashMap(shardingConditionValues.size(), 1.0f);
        String logicTableName = "";
        for (ShardingConditionValue each : shardingConditionValues) {
            if (each instanceof ListShardingConditionValue) {
                columnShardingValues.put(each.getColumnName(), ((ListShardingConditionValue)each).getValues());
            } else if (each instanceof RangeShardingConditionValue) {
                columnRangeValues.put(each.getColumnName(), ((RangeShardingConditionValue)each).getValueRange());
            }
            logicTableName = each.getTableName();
        }
        Collection shardingResult = this.shardingAlgorithm.doSharding(availableTargetNames, new ComplexKeysShardingValue(logicTableName, columnShardingValues, columnRangeValues));
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    @Override
    @Generated
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }

    @Generated
    public ComplexKeysShardingAlgorithm<?> getShardingAlgorithm() {
        return this.shardingAlgorithm;
    }
}

