/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.ShardingDDLRouteException;
import org.apache.shardingsphere.sharding.exception.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.RenameTableStatement;

public final class ShardingRenameTableStatementValidator
extends ShardingDDLStatementValidator<RenameTableStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<RenameTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database) {
        Collection tableNames = sqlStatementContext instanceof TableAvailable ? (Collection)((TableAvailable)sqlStatementContext).getAllTables().stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toList()) : sqlStatementContext.getTablesContext().getTableNames();
        List renameTables = ((RenameTableStatement)sqlStatementContext.getSqlStatement()).getRenameTables().stream().map(RenameTableDefinitionSegment::getRenameTable).collect(Collectors.toList());
        if (!renameTables.isEmpty() && this.containsShardingBroadcastTable(shardingRule, tableNames)) {
            throw new UnsupportedShardingOperationException("RENAME TABLE", ((SimpleTableSegment)renameTables.get(0)).getTableName().getIdentifier().getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsShardingBroadcastTable(ShardingRule shardingRule, Collection<String> tableNames) {
        if (shardingRule.tableRuleExists(tableNames)) return true;
        if (!tableNames.stream().anyMatch(shardingRule::isBroadcastTable)) return false;
        return true;
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<RenameTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        for (RenameTableDefinitionSegment each : ((RenameTableStatement)sqlStatementContext.getSqlStatement()).getRenameTables()) {
            String primaryTable = each.getTable().getTableName().getIdentifier().getValue();
            if (!this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, primaryTable)) continue;
            throw new ShardingDDLRouteException("RENAME", "TABLE", sqlStatementContext.getTablesContext().getTableNames());
        }
    }
}

