/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.DuplicatedIndexException;
import org.apache.shardingsphere.sharding.exception.IndexNotExistedException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class ShardingAlterIndexStatementValidator
extends ShardingDDLStatementValidator<AlterIndexStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<AlterIndexStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database) {
        Optional index = ((AlterIndexStatement)sqlStatementContext.getSqlStatement()).getIndex();
        String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)database.getName());
        ShardingSphereSchema schema = index.flatMap(optional -> optional.getOwner().map(owner -> database.getSchema(owner.getIdentifier().getValue()))).orElseGet(() -> database.getSchema(defaultSchemaName));
        if (index.isPresent() && !this.isSchemaContainsIndex(schema, (IndexSegment)index.get())) {
            throw new IndexNotExistedException(((IndexSegment)index.get()).getIndexName().getIdentifier().getValue());
        }
        Optional renameIndex = AlterIndexStatementHandler.getRenameIndexSegment((AlterIndexStatement)((AlterIndexStatement)sqlStatementContext.getSqlStatement()));
        if (renameIndex.isPresent() && this.isSchemaContainsIndex(schema, (IndexSegment)renameIndex.get())) {
            throw new DuplicatedIndexException(((IndexSegment)renameIndex.get()).getIndexName().getIdentifier().getValue());
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<AlterIndexStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
    }
}

