/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.unicast;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.CursorAvailable;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingUnicastRoutingEngine
implements ShardingRouteEngine {
    private final SQLStatementContext<?> sqlStatementContext;
    private final Collection<String> logicTables;

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        String dataSourceName = this.sqlStatementContext instanceof CursorAvailable ? shardingRule.getDataSourceNames().iterator().next() : this.getRandomDataSourceName(shardingRule.getDataSourceNames());
        RouteMapper dataSourceMapper = new RouteMapper(dataSourceName, dataSourceName);
        if (shardingRule.isAllBroadcastTables(this.logicTables)) {
            ArrayList<RouteMapper> tableMappers = new ArrayList<RouteMapper>(this.logicTables.size());
            for (String each : this.logicTables) {
                tableMappers.add(new RouteMapper(each, each));
            }
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, tableMappers));
        } else if (this.logicTables.isEmpty()) {
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
        } else if (1 == this.logicTables.size()) {
            String logicTableName = this.logicTables.iterator().next();
            if (!shardingRule.findTableRule(logicTableName).isPresent()) {
                result.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
                return result;
            }
            DataNode dataNode = shardingRule.getDataNode(logicTableName);
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(dataNode.getDataSourceName(), dataNode.getDataSourceName()), Collections.singletonList(new RouteMapper(logicTableName, dataNode.getTableName()))));
        } else {
            this.routeWithMultipleTables(result, shardingRule);
        }
        return result;
    }

    private void routeWithMultipleTables(RouteContext routeContext, ShardingRule shardingRule) throws ShardingSphereConfigurationException {
        ArrayList<RouteMapper> tableMappers = new ArrayList<RouteMapper>(this.logicTables.size());
        Set availableDataSourceNames = Collections.emptySet();
        boolean first = true;
        for (String each : this.logicTables) {
            TableRule tableRule = shardingRule.getTableRule(each);
            DataNode dataNode = tableRule.getActualDataNodes().get(0);
            tableMappers.add(new RouteMapper(each, dataNode.getTableName()));
            Set currentDataSourceNames = tableRule.getActualDataNodes().stream().map(DataNode::getDataSourceName).collect(Collectors.toCollection(() -> new HashSet(tableRule.getActualDataSourceNames().size())));
            if (first) {
                availableDataSourceNames = currentDataSourceNames;
                first = false;
                continue;
            }
            availableDataSourceNames = Sets.intersection((Set)availableDataSourceNames, (Set)currentDataSourceNames);
        }
        if (availableDataSourceNames.isEmpty()) {
            throw new ShardingSphereConfigurationException("Cannot find actual datasource intersection for logic tables: %s", this.logicTables.toArray(new String[0]));
        }
        String dataSourceName = this.getRandomDataSourceName(availableDataSourceNames);
        routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), tableMappers));
    }

    private String getRandomDataSourceName(Collection<String> dataSourceNames) {
        return new ArrayList<String>(dataSourceNames).get(ThreadLocalRandom.current().nextInt(dataSourceNames.size()));
    }

    @Generated
    public ShardingUnicastRoutingEngine(SQLStatementContext<?> sqlStatementContext, Collection<String> logicTables) {
        this.sqlStatementContext = sqlStatementContext;
        this.logicTables = logicTables;
    }
}

