/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.standard;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategyFactory;
import org.apache.shardingsphere.sharding.route.strategy.type.hint.HintShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.type.none.NoneShardingStrategy;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ShardingStandardRoutingEngine
implements ShardingRouteEngine {
    private final String logicTableName;
    private final ShardingConditions shardingConditions;
    private final ConfigurationProperties properties;
    private final Collection<Collection<DataNode>> originalDataNodes = new LinkedList<Collection<DataNode>>();

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        Collection<DataNode> dataNodes = this.getDataNodes(shardingRule, shardingRule.getTableRule(this.logicTableName));
        result.getOriginalDataNodes().addAll(this.originalDataNodes);
        for (DataNode each : dataNodes) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), Collections.singleton(new RouteMapper(this.logicTableName, each.getTableName()))));
        }
        return result;
    }

    private Collection<DataNode> getDataNodes(ShardingRule shardingRule, TableRule tableRule) {
        ShardingStrategy databaseShardingStrategy = this.createShardingStrategy(shardingRule.getDatabaseShardingStrategyConfiguration(tableRule), shardingRule.getShardingAlgorithms(), shardingRule.getDefaultShardingColumn());
        ShardingStrategy tableShardingStrategy = this.createShardingStrategy(shardingRule.getTableShardingStrategyConfiguration(tableRule), shardingRule.getShardingAlgorithms(), shardingRule.getDefaultShardingColumn());
        if (this.isRoutingByHint(shardingRule, tableRule)) {
            return this.routeByHint(tableRule, databaseShardingStrategy, tableShardingStrategy);
        }
        if (this.isRoutingByShardingConditions(shardingRule, tableRule)) {
            return this.routeByShardingConditions(shardingRule, tableRule, databaseShardingStrategy, tableShardingStrategy);
        }
        return this.routeByMixedConditions(shardingRule, tableRule, databaseShardingStrategy, tableShardingStrategy);
    }

    private boolean isRoutingByHint(ShardingRule shardingRule, TableRule tableRule) {
        return shardingRule.getDatabaseShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration && shardingRule.getTableShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration;
    }

    private Collection<DataNode> routeByHint(TableRule tableRule, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        return this.route0(tableRule, databaseShardingStrategy, this.getDatabaseShardingValuesFromHint(), tableShardingStrategy, this.getTableShardingValuesFromHint());
    }

    private boolean isRoutingByShardingConditions(ShardingRule shardingRule, TableRule tableRule) {
        return !(shardingRule.getDatabaseShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration) && !(shardingRule.getTableShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration);
    }

    private Collection<DataNode> routeByShardingConditions(ShardingRule shardingRule, TableRule tableRule, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        return this.shardingConditions.getConditions().isEmpty() ? this.route0(tableRule, databaseShardingStrategy, Collections.emptyList(), tableShardingStrategy, Collections.emptyList()) : this.routeByShardingConditionsWithCondition(shardingRule, tableRule, databaseShardingStrategy, tableShardingStrategy);
    }

    private Collection<DataNode> routeByShardingConditionsWithCondition(ShardingRule shardingRule, TableRule tableRule, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getConditions()) {
            Collection<DataNode> dataNodes = this.route0(tableRule, databaseShardingStrategy, this.getShardingValuesFromShardingConditions(shardingRule, databaseShardingStrategy.getShardingColumns(), each), tableShardingStrategy, this.getShardingValuesFromShardingConditions(shardingRule, tableShardingStrategy.getShardingColumns(), each));
            result.addAll(dataNodes);
            this.originalDataNodes.add(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditions(ShardingRule shardingRule, TableRule tableRule, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        return this.shardingConditions.getConditions().isEmpty() ? this.routeByMixedConditionsWithHint(shardingRule, tableRule, databaseShardingStrategy, tableShardingStrategy) : this.routeByMixedConditionsWithCondition(shardingRule, tableRule, databaseShardingStrategy, tableShardingStrategy);
    }

    private Collection<DataNode> routeByMixedConditionsWithCondition(ShardingRule shardingRule, TableRule tableRule, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getConditions()) {
            Collection<DataNode> dataNodes = this.route0(tableRule, databaseShardingStrategy, this.getDatabaseShardingValues(shardingRule, databaseShardingStrategy, each), tableShardingStrategy, this.getTableShardingValues(shardingRule, tableShardingStrategy, each));
            result.addAll(dataNodes);
            this.originalDataNodes.add(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditionsWithHint(ShardingRule shardingRule, TableRule tableRule, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        if (shardingRule.getDatabaseShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration) {
            return this.route0(tableRule, databaseShardingStrategy, this.getDatabaseShardingValuesFromHint(), tableShardingStrategy, Collections.emptyList());
        }
        return this.route0(tableRule, databaseShardingStrategy, Collections.emptyList(), tableShardingStrategy, this.getTableShardingValuesFromHint());
    }

    private List<ShardingConditionValue> getDatabaseShardingValues(ShardingRule shardingRule, ShardingStrategy databaseShardingStrategy, ShardingCondition shardingCondition) {
        return this.isGettingShardingValuesFromHint(databaseShardingStrategy) ? this.getDatabaseShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(shardingRule, databaseShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private List<ShardingConditionValue> getTableShardingValues(ShardingRule shardingRule, ShardingStrategy tableShardingStrategy, ShardingCondition shardingCondition) {
        return this.isGettingShardingValuesFromHint(tableShardingStrategy) ? this.getTableShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(shardingRule, tableShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private boolean isGettingShardingValuesFromHint(ShardingStrategy shardingStrategy) {
        return shardingStrategy instanceof HintShardingStrategy;
    }

    private List<ShardingConditionValue> getDatabaseShardingValuesFromHint() {
        return this.getShardingConditions(HintManager.isDatabaseShardingOnly() ? HintManager.getDatabaseShardingValues() : HintManager.getDatabaseShardingValues((String)this.logicTableName));
    }

    private List<ShardingConditionValue> getTableShardingValuesFromHint() {
        return this.getShardingConditions(HintManager.getTableShardingValues((String)this.logicTableName));
    }

    private List<ShardingConditionValue> getShardingConditions(Collection<Comparable<?>> shardingValue) {
        return shardingValue.isEmpty() ? Collections.emptyList() : Collections.singletonList(new ListShardingConditionValue("", this.logicTableName, shardingValue));
    }

    private List<ShardingConditionValue> getShardingValuesFromShardingConditions(ShardingRule shardingRule, Collection<String> shardingColumns, ShardingCondition shardingCondition) {
        ArrayList<ShardingConditionValue> result = new ArrayList<ShardingConditionValue>(shardingColumns.size());
        for (ShardingConditionValue each : shardingCondition.getValues()) {
            Optional<BindingTableRule> bindingTableRule = shardingRule.findBindingTableRule(each.getTableName());
            if (!this.logicTableName.equals(each.getTableName()) && (!bindingTableRule.isPresent() || !bindingTableRule.get().hasLogicTable(this.logicTableName)) || !shardingColumns.contains(each.getColumnName())) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<DataNode> route0(TableRule tableRule, ShardingStrategy databaseShardingStrategy, List<ShardingConditionValue> databaseShardingValues, ShardingStrategy tableShardingStrategy, List<ShardingConditionValue> tableShardingValues) {
        Collection<String> routedDataSources = this.routeDataSources(tableRule, databaseShardingStrategy, databaseShardingValues);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedDataSources) {
            result.addAll(this.routeTables(tableRule, each, tableShardingStrategy, tableShardingValues));
        }
        return result;
    }

    private Collection<String> routeDataSources(TableRule tableRule, ShardingStrategy databaseShardingStrategy, List<ShardingConditionValue> databaseShardingValues) {
        if (databaseShardingValues.isEmpty()) {
            return tableRule.getActualDataSourceNames();
        }
        Collection<String> result = databaseShardingStrategy.doSharding(tableRule.getActualDataSourceNames(), databaseShardingValues, tableRule.getDataSourceDataNode(), this.properties);
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"No database route info");
        Preconditions.checkState((boolean)tableRule.getActualDataSourceNames().containsAll(result), (String)"Some routed data sources do not belong to configured data sources. routed data sources: `%s`, configured data sources: `%s`", result, tableRule.getActualDataSourceNames());
        return result;
    }

    private Collection<DataNode> routeTables(TableRule tableRule, String routedDataSource, ShardingStrategy tableShardingStrategy, List<ShardingConditionValue> tableShardingValues) {
        Collection<String> availableTargetTables = tableRule.getActualTableNames(routedDataSource);
        Collection<String> routedTables = tableShardingValues.isEmpty() ? availableTargetTables : tableShardingStrategy.doSharding(availableTargetTables, tableShardingValues, tableRule.getTableDataNode(), this.properties);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedTables) {
            result.add(new DataNode(routedDataSource, each));
        }
        return result;
    }

    private ShardingStrategy createShardingStrategy(ShardingStrategyConfiguration shardingStrategyConfig, Map<String, ShardingAlgorithm> shardingAlgorithms, String defaultShardingColumn) {
        return null == shardingStrategyConfig ? new NoneShardingStrategy() : ShardingStrategyFactory.newInstance(shardingStrategyConfig, shardingAlgorithms.get(shardingStrategyConfig.getShardingAlgorithmName()), defaultShardingColumn);
    }

    @Generated
    public ShardingStandardRoutingEngine(String logicTableName, ShardingConditions shardingConditions, ConfigurationProperties properties) {
        this.logicTableName = logicTableName;
        this.shardingConditions = shardingConditions;
        this.properties = properties;
    }
}

