/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine.impl;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.exception.ShardingValueDataTypeException;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGeneratorFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.value.AlwaysFalseShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.SafeNumberOperationUtil;

public final class WhereClauseShardingConditionEngine
implements ShardingConditionEngine<SQLStatementContext<?>> {
    private final ShardingRule shardingRule;
    private final ShardingSphereDatabase database;

    @Override
    public List<ShardingCondition> createShardingConditions(SQLStatementContext<?> sqlStatementContext, List<Object> parameters) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        Collection columnSegments = ((WhereAvailable)sqlStatementContext).getColumnSegments();
        String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.database.getName());
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)this.database).getSchema(arg_0)).orElseGet(() -> this.database.getSchema(defaultSchemaName));
        Map columnExpressionTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(columnSegments, schema);
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>();
        for (WhereSegment each : ((WhereAvailable)sqlStatementContext).getWhereSegments()) {
            result.addAll(this.createShardingConditions(each.getExpr(), parameters, columnExpressionTableNames));
        }
        return result;
    }

    private Collection<ShardingCondition> createShardingConditions(ExpressionSegment expression, List<Object> parameters, Map<String, String> columnExpressionTableNames) {
        Collection andPredicates = ExpressionExtractUtil.getAndPredicates((ExpressionSegment)expression);
        LinkedList<ShardingCondition> result = new LinkedList<ShardingCondition>();
        for (AndPredicate each : andPredicates) {
            Map<Column, Collection<ShardingConditionValue>> shardingConditionValues = this.createShardingConditionValueMap(each.getPredicates(), parameters, columnExpressionTableNames);
            if (shardingConditionValues.isEmpty()) {
                return Collections.emptyList();
            }
            ShardingCondition shardingCondition = this.createShardingCondition(shardingConditionValues);
            shardingCondition.setStartIndex(expression.getStartIndex());
            result.add(shardingCondition);
        }
        return result;
    }

    private Map<Column, Collection<ShardingConditionValue>> createShardingConditionValueMap(Collection<ExpressionSegment> predicates, List<Object> parameters, Map<String, String> columnTableNames) {
        HashMap<Column, Collection<ShardingConditionValue>> result = new HashMap<Column, Collection<ShardingConditionValue>>(predicates.size(), 1.0f);
        for (ExpressionSegment each : predicates) {
            for (ColumnSegment columnSegment : ColumnExtractor.extract((ExpressionSegment)each)) {
                Column column;
                Optional<ShardingConditionValue> shardingConditionValue;
                Optional<String> tableName = Optional.ofNullable(columnTableNames.get(columnSegment.getExpression()));
                Optional shardingColumn = tableName.flatMap(optional -> this.shardingRule.findShardingColumn(columnSegment.getIdentifier().getValue(), (String)optional));
                if (!tableName.isPresent() || !shardingColumn.isPresent() || !(shardingConditionValue = ConditionValueGeneratorFactory.generate(each, column = new Column((String)shardingColumn.get(), tableName.get()), parameters)).isPresent()) continue;
                result.computeIfAbsent(column, unused -> new LinkedList()).add(shardingConditionValue.get());
            }
        }
        return result;
    }

    private ShardingCondition createShardingCondition(Map<Column, Collection<ShardingConditionValue>> shardingConditionValues) {
        ShardingCondition result = new ShardingCondition();
        for (Map.Entry<Column, Collection<ShardingConditionValue>> entry : shardingConditionValues.entrySet()) {
            try {
                ShardingConditionValue shardingConditionValue = this.mergeShardingConditionValues(entry.getKey(), entry.getValue());
                if (shardingConditionValue instanceof AlwaysFalseShardingConditionValue) {
                    return new AlwaysFalseShardingCondition();
                }
                result.getValues().add(shardingConditionValue);
            }
            catch (ClassCastException ex) {
                throw new ShardingValueDataTypeException(entry.getKey());
            }
        }
        return result;
    }

    private ShardingConditionValue mergeShardingConditionValues(Column column, Collection<ShardingConditionValue> shardingConditionValues) {
        Collection<Comparable<?>> listValue = null;
        Range<Comparable<?>> rangeValue = null;
        for (ShardingConditionValue each : shardingConditionValues) {
            if (each instanceof ListShardingConditionValue) {
                listValue = this.mergeListShardingValues(((ListShardingConditionValue)each).getValues(), listValue);
                if (!listValue.isEmpty()) continue;
                return new AlwaysFalseShardingConditionValue();
            }
            if (!(each instanceof RangeShardingConditionValue)) continue;
            try {
                rangeValue = this.mergeRangeShardingValues(((RangeShardingConditionValue)each).getValueRange(), rangeValue);
            }
            catch (IllegalArgumentException ex) {
                return new AlwaysFalseShardingConditionValue();
            }
        }
        if (null == listValue) {
            return new RangeShardingConditionValue(column.getName(), column.getTableName(), rangeValue);
        }
        if (null == rangeValue) {
            return new ListShardingConditionValue(column.getName(), column.getTableName(), listValue);
        }
        return (listValue = this.mergeListAndRangeShardingValues(listValue, rangeValue)).isEmpty() ? new AlwaysFalseShardingConditionValue() : new ListShardingConditionValue(column.getName(), column.getTableName(), listValue);
    }

    private Collection<Comparable<?>> mergeListShardingValues(Collection<Comparable<?>> value1, Collection<Comparable<?>> value2) {
        if (null == value2) {
            return value1;
        }
        value1.retainAll(value2);
        return value1;
    }

    private Range<Comparable<?>> mergeRangeShardingValues(Range<Comparable<?>> value1, Range<Comparable<?>> value2) {
        return null == value2 ? value1 : SafeNumberOperationUtil.safeIntersection(value1, value2);
    }

    private Collection<Comparable<?>> mergeListAndRangeShardingValues(Collection<Comparable<?>> listValue, Range<Comparable<?>> rangeValue) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : listValue) {
            if (!SafeNumberOperationUtil.safeContains(rangeValue, each)) continue;
            result.add(each);
        }
        return result;
    }

    @Generated
    public WhereClauseShardingConditionEngine(ShardingRule shardingRule, ShardingSphereDatabase database) {
        this.shardingRule = shardingRule;
        this.database = database;
    }
}

