/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.shardingsphere.dialect.exception.data.InsertColumnsAndValuesMismatchedException;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.datetime.DatetimeService;
import org.apache.shardingsphere.infra.datetime.DatetimeServiceFactory;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.exception.NullShardingValueException;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.impl.WhereClauseShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class InsertClauseShardingConditionEngine
implements ShardingConditionEngine<InsertStatementContext> {
    private final ShardingRule shardingRule;
    private final ShardingSphereDatabase database;

    @Override
    public List<ShardingCondition> createShardingConditions(InsertStatementContext sqlStatementContext, List<Object> parameters) {
        List<ShardingCondition> result = null == sqlStatementContext.getInsertSelectContext() ? this.createShardingConditionsWithInsertValues(sqlStatementContext, parameters) : this.createShardingConditionsWithInsertSelect(sqlStatementContext, parameters);
        this.appendGeneratedKeyConditions(sqlStatementContext, result);
        return result;
    }

    private List<ShardingCondition> createShardingConditionsWithInsertValues(InsertStatementContext sqlStatementContext, List<Object> parameters) {
        String tableName = ((InsertStatement)sqlStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Collection<String> columnNames = this.getColumnNames(sqlStatementContext);
        List insertValueContexts = sqlStatementContext.getInsertValueContexts();
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>(insertValueContexts.size());
        int rowNumber = 0;
        for (InsertValueContext each : insertValueContexts) {
            result.add(this.createShardingCondition(tableName, columnNames.iterator(), each, parameters, ++rowNumber));
        }
        return result;
    }

    private Collection<String> getColumnNames(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        if (generatedKey.isPresent() && ((GeneratedKeyContext)generatedKey.get()).isGenerated()) {
            LinkedList<String> result = new LinkedList<String>(insertStatementContext.getColumnNames());
            result.remove(((GeneratedKeyContext)generatedKey.get()).getColumnName());
            return result;
        }
        return insertStatementContext.getColumnNames();
    }

    private ShardingCondition createShardingCondition(String tableName, Iterator<String> columnNames, InsertValueContext insertValueContext, List<Object> parameters, int rowNumber) {
        ShardingCondition result = new ShardingCondition();
        DatetimeService datetimeService = null;
        for (ExpressionSegment each : insertValueContext.getValueExpressions()) {
            if (!columnNames.hasNext()) {
                throw new InsertColumnsAndValuesMismatchedException(rowNumber);
            }
            Optional<String> shardingColumn = this.shardingRule.findShardingColumn(columnNames.next(), tableName);
            if (!shardingColumn.isPresent()) continue;
            if (each instanceof SimpleExpressionSegment) {
                result.getValues().add(new ListShardingConditionValue(shardingColumn.get(), tableName, Collections.singletonList(this.getShardingValue((SimpleExpressionSegment)each, parameters))));
                continue;
            }
            if (each instanceof CommonExpressionSegment) {
                this.generateShardingCondition((CommonExpressionSegment)each, result, shardingColumn.get(), tableName);
                continue;
            }
            if (ExpressionConditionUtils.isNowExpression(each)) {
                if (null == datetimeService) {
                    datetimeService = DatetimeServiceFactory.getInstance();
                }
                result.getValues().add(new ListShardingConditionValue<Date>(shardingColumn.get(), tableName, Collections.singletonList(datetimeService.getDatetime())));
                continue;
            }
            if (!ExpressionConditionUtils.isNullExpression(each)) continue;
            throw new NullShardingValueException();
        }
        return result;
    }

    private void generateShardingCondition(CommonExpressionSegment expressionSegment, ShardingCondition result, String shardingColumn, String tableName) {
        try {
            Integer value = Integer.valueOf(expressionSegment.getText());
            result.getValues().add(new ListShardingConditionValue<Integer>(shardingColumn, tableName, Collections.singletonList(value)));
        }
        catch (NumberFormatException ex) {
            result.getValues().add(new ListShardingConditionValue<String>(shardingColumn, tableName, Collections.singletonList(expressionSegment.getText())));
        }
    }

    private Comparable<?> getShardingValue(SimpleExpressionSegment expressionSegment, List<Object> parameters) {
        Object result = expressionSegment instanceof ParameterMarkerExpressionSegment ? parameters.get(((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex()) : ((LiteralExpressionSegment)expressionSegment).getLiterals();
        Preconditions.checkArgument((boolean)(result instanceof Comparable), (Object)"Sharding value must implements Comparable.");
        return (Comparable)result;
    }

    private List<ShardingCondition> createShardingConditionsWithInsertSelect(InsertStatementContext sqlStatementContext, List<Object> parameters) {
        SelectStatementContext selectStatementContext = sqlStatementContext.getInsertSelectContext().getSelectStatementContext();
        return new LinkedList<ShardingCondition>(new WhereClauseShardingConditionEngine(this.shardingRule, this.database).createShardingConditions((SQLStatementContext<?>)selectStatementContext, parameters));
    }

    private void appendGeneratedKeyConditions(InsertStatementContext sqlStatementContext, List<ShardingCondition> shardingConditions) {
        Optional generatedKey = sqlStatementContext.getGeneratedKeyContext();
        String tableName = ((InsertStatement)sqlStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        if (generatedKey.isPresent() && ((GeneratedKeyContext)generatedKey.get()).isGenerated() && this.shardingRule.findTableRule(tableName).isPresent()) {
            ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().addAll(this.generateKeys(tableName, sqlStatementContext.getValueListCount()));
            if (this.shardingRule.findShardingColumn(((GeneratedKeyContext)generatedKey.get()).getColumnName(), tableName).isPresent()) {
                this.appendGeneratedKeyCondition((GeneratedKeyContext)generatedKey.get(), tableName, shardingConditions);
            }
        }
    }

    private Collection<Comparable<?>> generateKeys(String tableName, int valueListCount) {
        return IntStream.range(0, valueListCount).mapToObj(each -> this.shardingRule.generateKey(tableName)).collect(Collectors.toList());
    }

    private void appendGeneratedKeyCondition(GeneratedKeyContext generatedKey, String tableName, List<ShardingCondition> shardingConditions) {
        Iterator generatedValuesIterator = generatedKey.getGeneratedValues().iterator();
        for (ShardingCondition each : shardingConditions) {
            each.getValues().add(new ListShardingConditionValue(generatedKey.getColumnName(), tableName, Collections.singletonList(generatedValuesIterator.next())));
        }
    }

    @Generated
    public InsertClauseShardingConditionEngine(ShardingRule shardingRule, ShardingSphereDatabase database) {
        this.shardingRule = shardingRule;
        this.database = database;
    }
}

