/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.builder.SQLTokenGeneratorBuilder;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.AggregationDistinctTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ConstraintTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.CursorTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.DistinctProjectionPrefixTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.FetchDirectionTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.IndexTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.OffsetTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.OrderByTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ProjectionsTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.RowCountTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingInsertValuesTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingRemoveTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.TableTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.GeneratedKeyAssignmentTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.GeneratedKeyForUseDefaultInsertColumnsTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.GeneratedKeyInsertColumnTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.GeneratedKeyInsertValuesTokenGenerator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;

public final class ShardingTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final ShardingRule shardingRule;
    private final RouteContext routeContext;
    private final SQLStatementContext<?> sqlStatementContext;

    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new TableTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new DistinctProjectionPrefixTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ProjectionsTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new OrderByTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new AggregationDistinctTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new IndexTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ConstraintTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new OffsetTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new RowCountTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyInsertColumnTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyForUseDefaultInsertColumnsTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyAssignmentTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingInsertValuesTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyInsertValuesTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingRemoveTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new CursorTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new FetchDirectionTokenGenerator());
        return result;
    }

    private void addSQLTokenGenerator(Collection<SQLTokenGenerator> sqlTokenGenerators, SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        if (toBeAddedSQLTokenGenerator instanceof IgnoreForSingleRoute && this.routeContext.isSingleRouting()) {
            return;
        }
        if (toBeAddedSQLTokenGenerator instanceof ShardingRuleAware) {
            ((ShardingRuleAware)toBeAddedSQLTokenGenerator).setShardingRule(this.shardingRule);
        }
        if (toBeAddedSQLTokenGenerator instanceof RouteContextAware) {
            ((RouteContextAware)toBeAddedSQLTokenGenerator).setRouteContext(this.routeContext);
        }
        if (toBeAddedSQLTokenGenerator.isGenerateSQLToken(this.sqlStatementContext)) {
            sqlTokenGenerators.add(toBeAddedSQLTokenGenerator);
        }
    }

    @Generated
    public ShardingTokenGenerateBuilder(ShardingRule shardingRule, RouteContext routeContext, SQLStatementContext<?> sqlStatementContext) {
        this.shardingRule = shardingRule;
        this.routeContext = routeContext;
        this.sqlStatementContext = sqlStatementContext;
    }
}

