/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.OrderByToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class OrderByTokenGenerator
implements OptionalSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getOrderByContext().isGenerated();
    }

    public OrderByToken generateSQLToken(SelectStatementContext selectStatementContext) {
        OrderByToken result = new OrderByToken(this.getGenerateOrderByStartIndex(selectStatementContext));
        for (OrderByItem each : selectStatementContext.getOrderByContext().getItems()) {
            String columnLabel;
            if (each.getSegment() instanceof ColumnOrderByItemSegment) {
                ColumnOrderByItemSegment columnOrderByItemSegment = (ColumnOrderByItemSegment)each.getSegment();
                columnLabel = columnOrderByItemSegment.getText();
            } else {
                columnLabel = each.getSegment() instanceof ExpressionOrderByItemSegment ? ((ExpressionOrderByItemSegment)each.getSegment()).getText() : String.valueOf(each.getIndex());
            }
            result.getColumnLabels().add(columnLabel);
            result.getOrderDirections().add(each.getSegment().getOrderDirection());
        }
        return result;
    }

    private int getGenerateOrderByStartIndex(SelectStatementContext selectStatementContext) {
        SelectStatement sqlStatement = (SelectStatement)selectStatementContext.getSqlStatement();
        int stopIndex = SelectStatementHandler.getWindowSegment((SelectStatement)sqlStatement).isPresent() ? ((WindowSegment)SelectStatementHandler.getWindowSegment((SelectStatement)sqlStatement).get()).getStopIndex() : (sqlStatement.getHaving().isPresent() ? ((HavingSegment)sqlStatement.getHaving().get()).getStopIndex() : (sqlStatement.getGroupBy().isPresent() ? ((GroupBySegment)sqlStatement.getGroupBy().get()).getStopIndex() : (sqlStatement.getWhere().isPresent() ? ((WhereSegment)sqlStatement.getWhere().get()).getStopIndex() : selectStatementContext.getAllTables().stream().mapToInt(SimpleTableSegment::getStopIndex).max().orElse(0))));
        return stopIndex + 1;
    }
}

