/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.IndexToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;

public final class IndexTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
ShardingRuleAware,
SchemaMetaDataAware {
    private ShardingRule shardingRule;
    private String databaseName;
    private Map<String, ShardingSphereSchema> schemas;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof IndexAvailable && !((IndexAvailable)sqlStatementContext).getIndexes().isEmpty();
    }

    public Collection<IndexToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        LinkedList<IndexToken> result = new LinkedList<IndexToken>();
        String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.databaseName);
        if (sqlStatementContext instanceof IndexAvailable) {
            for (IndexSegment each : ((IndexAvailable)sqlStatementContext).getIndexes()) {
                ShardingSphereSchema schema = each.getOwner().isPresent() ? this.schemas.get(((OwnerSegment)each.getOwner().get()).getIdentifier().getValue()) : this.schemas.get(defaultSchemaName);
                result.add(new IndexToken(each.getIndexName().getStartIndex(), each.getStopIndex(), each.getIndexName().getIdentifier(), sqlStatementContext, this.shardingRule, schema));
            }
        }
        return result;
    }

    @Override
    @Generated
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }
}

