/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShowTableStatusMergedResult
extends MemoryMergedResult<ShardingRule> {
    public ShowTableStatusMergedResult(ShardingRule shardingRule, SQLStatementContext<?> sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super((ShardingSphereRule)shardingRule, schema, sqlStatementContext, queryResults);
    }

    protected List<MemoryQueryResultRow> init(ShardingRule shardingRule, ShardingSphereSchema schema, SQLStatementContext<?> sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        LinkedHashMap<String, MemoryQueryResultRow> memoryQueryResultRows = new LinkedHashMap<String, MemoryQueryResultRow>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                Optional<TableRule> tableRule = shardingRule.findTableRuleByActualTable(actualTableName);
                tableRule.ifPresent(optional -> memoryResultSetRow.setCell(1, (Object)optional.getLogicTable()));
                String tableName = memoryResultSetRow.getCell(1).toString();
                if (memoryQueryResultRows.containsKey(tableName)) {
                    this.merge((MemoryQueryResultRow)memoryQueryResultRows.get(tableName), memoryResultSetRow);
                    continue;
                }
                memoryQueryResultRows.put(tableName, memoryResultSetRow);
            }
        }
        return new LinkedList<MemoryQueryResultRow>(memoryQueryResultRows.values());
    }

    private void merge(MemoryQueryResultRow row, MemoryQueryResultRow newRow) {
        row.setCell(5, (Object)this.sum(row.getCell(5), newRow.getCell(5)));
        row.setCell(7, (Object)this.sum(row.getCell(7), newRow.getCell(7)));
        row.setCell(8, (Object)this.sum(row.getCell(8), newRow.getCell(8)));
        row.setCell(9, (Object)this.sum(row.getCell(9), newRow.getCell(9)));
        row.setCell(10, (Object)this.sum(row.getCell(10), newRow.getCell(10)));
        row.setCell(6, (Object)this.avg(row.getCell(7), row.getCell(5)));
    }

    private BigInteger sum(Object num1, Object num2) {
        return ((BigInteger)num1).add((BigInteger)num2);
    }

    private BigInteger avg(Object sum, Object number) {
        return BigInteger.ZERO.equals(number) ? BigInteger.ZERO : ((BigInteger)sum).divide((BigInteger)number);
    }
}

