/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.decider;

import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.decider.SQLFederationDecider;
import org.apache.shardingsphere.infra.binder.decider.context.SQLFederationDeciderContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngineFactory;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingSQLFederationDecider
implements SQLFederationDecider<ShardingRule> {
    public void decide(SQLFederationDeciderContext deciderContext, QueryContext queryContext, ShardingSphereDatabase database, ShardingRule rule, ConfigurationProperties props) {
        SelectStatementContext select = (SelectStatementContext)queryContext.getSqlStatementContext();
        Collection<String> tableNames = rule.getShardingLogicTableNames(select.getTablesContext().getTableNames());
        if (tableNames.isEmpty()) {
            return;
        }
        ShardingSQLFederationDecider.addTableDataNodes(deciderContext, rule, tableNames);
        ShardingConditions shardingConditions = ShardingSQLFederationDecider.createShardingConditions(queryContext, database, rule);
        if (select.getPaginationContext().isHasPagination() || shardingConditions.isNeedMerge() && shardingConditions.isSameShardingCondition()) {
            return;
        }
        if (select.isContainsSubquery() || select.isContainsHaving() || select.isContainsCombine() || select.isContainsPartialDistinctAggregation()) {
            deciderContext.setUseSQLFederation(true);
            return;
        }
        if (!select.isContainsJoinQuery() || rule.isAllTablesInSameDataSource(tableNames)) {
            return;
        }
        boolean allBindingTables = tableNames.size() > 1 && rule.isAllBindingTables(database, (SQLStatementContext<?>)select, tableNames);
        deciderContext.setUseSQLFederation(tableNames.size() > 1 && !allBindingTables);
    }

    private static void addTableDataNodes(SQLFederationDeciderContext deciderContext, ShardingRule rule, Collection<String> tableNames) {
        for (String each : tableNames) {
            rule.findTableRule(each).ifPresent(optional -> deciderContext.getDataNodes().addAll(optional.getActualDataNodes()));
        }
    }

    private static ShardingConditions createShardingConditions(QueryContext queryContext, ShardingSphereDatabase database, ShardingRule rule) {
        ShardingConditionEngine<?> shardingConditionEngine = ShardingConditionEngineFactory.createShardingConditionEngine(queryContext, database, rule);
        List<ShardingCondition> shardingConditions = shardingConditionEngine.createShardingConditions(queryContext.getSqlStatementContext(), queryContext.getParameters());
        return new ShardingConditions(shardingConditions, queryContext.getSqlStatementContext(), rule);
    }

    public int getOrder() {
        return -10;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

