/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.range;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Range;
import com.google.common.primitives.Longs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.sharding.algorithm.sharding.range.AbstractRangeShardingAlgorithm;

public final class BoundaryBasedRangeShardingAlgorithm
extends AbstractRangeShardingAlgorithm {
    private static final String SHARDING_RANGES_KEY = "sharding-ranges";

    @Override
    public Map<Integer, Range<Comparable<?>>> calculatePartitionRange(Properties props) {
        Preconditions.checkState((boolean)props.containsKey(SHARDING_RANGES_KEY), (Object)"Sharding ranges cannot be null.");
        List partitionRanges = Splitter.on((String)",").trimResults().splitToList((CharSequence)props.getProperty(SHARDING_RANGES_KEY)).stream().map(Longs::tryParse).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        Preconditions.checkArgument((!partitionRanges.isEmpty() ? 1 : 0) != 0, (Object)"Sharding ranges is not valid.");
        HashMap result = new HashMap(partitionRanges.size() + 1, 1.0f);
        for (int i = 0; i < partitionRanges.size(); ++i) {
            Long rangeValue = (Long)partitionRanges.get(i);
            if (0 == i) {
                result.put(0, Range.lessThan((Comparable)rangeValue));
            } else {
                Long previousRangeValue = (Long)partitionRanges.get(i - 1);
                result.put(i, Range.closedOpen((Comparable)previousRangeValue, (Comparable)rangeValue));
            }
            if (i != partitionRanges.size() - 1) continue;
            result.put(i + 1, Range.atLeast((Comparable)rangeValue));
        }
        return result;
    }

    public String getType() {
        return "BOUNDARY_RANGE";
    }
}

