/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.inline;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.util.Expando;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.expr.InlineExpressionParser;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.MismatchedInlineShardingAlgorithmExpressionAndColumnException;

public final class InlineShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String ALLOW_RANGE_QUERY_KEY = "allow-range-query-with-inline-sharding";
    private Properties props;
    private String algorithmExpression;
    private boolean allowRangeQuery;

    public void init(Properties props) {
        this.props = props;
        this.algorithmExpression = this.getAlgorithmExpression(props);
        this.allowRangeQuery = this.isAllowRangeQuery(props);
    }

    private String getAlgorithmExpression(Properties props) {
        String expression = props.getProperty(ALGORITHM_EXPRESSION_KEY);
        Preconditions.checkState((null != expression && !expression.isEmpty() ? 1 : 0) != 0, (Object)"Inline sharding algorithm expression cannot be null or empty.");
        return InlineExpressionParser.handlePlaceHolder((String)expression.trim());
    }

    private boolean isAllowRangeQuery(Properties props) {
        return Boolean.parseBoolean(props.getOrDefault((Object)ALLOW_RANGE_QUERY_KEY, Boolean.FALSE.toString()).toString());
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        Closure<?> closure = this.createClosure();
        Comparable value = shardingValue.getValue();
        if (value instanceof Number) {
            value = Integer.valueOf(Math.abs(((Number)((Object)value)).intValue()));
        }
        closure.setProperty(shardingValue.getColumnName(), (Object)value);
        return this.getTargetShardingNode(closure, shardingValue.getColumnName());
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        if (this.allowRangeQuery) {
            return availableTargetNames;
        }
        throw new UnsupportedOperationException("Since the property of `allow-range-query-with-inline-sharding` is false, inline sharding algorithm can not tackle with range query.");
    }

    private Closure<?> createClosure() {
        Closure result = new InlineExpressionParser(this.algorithmExpression).evaluateClosure().rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        return result;
    }

    private String getTargetShardingNode(Closure<?> closure, String columnName) {
        try {
            return closure.call().toString();
        }
        catch (MissingMethodException | NullPointerException ex) {
            throw new MismatchedInlineShardingAlgorithmExpressionAndColumnException(this.algorithmExpression, columnName);
        }
    }

    public String getType() {
        return "INLINE";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

