/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class AutoIntervalShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    private static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    private static final String SHARDING_SECONDS_KEY = "sharding-seconds";
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private Properties props;
    private LocalDateTime dateTimeLower;
    private long shardingSeconds;
    private int autoTablesAmount;

    public void init(Properties props) {
        this.props = props;
        this.dateTimeLower = this.getDateTime(props);
        this.shardingSeconds = this.getShardingSeconds(props);
        this.autoTablesAmount = (int)(Math.ceil(this.parseDate((Comparable<?>)((Object)props.getProperty(DATE_TIME_UPPER_KEY))) / this.shardingSeconds) + 2.0);
    }

    private LocalDateTime getDateTime(Properties props) {
        String value = props.getProperty(DATE_TIME_LOWER_KEY);
        Preconditions.checkNotNull((Object)value, (String)"%s cannot be null.", (Object)DATE_TIME_LOWER_KEY);
        try {
            return LocalDateTime.parse(value, DATE_TIME_FORMAT);
        }
        catch (DateTimeParseException ex) {
            throw new ShardingSphereConfigurationException("Invalid %s, datetime pattern should be `yyyy-MM-dd HH:mm:ss`, value is `%s`", new String[]{DATE_TIME_LOWER_KEY, value});
        }
    }

    private long getShardingSeconds(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(SHARDING_SECONDS_KEY), (String)"%s cannot be null.", (Object)SHARDING_SECONDS_KEY);
        return Long.parseLong(props.getProperty(SHARDING_SECONDS_KEY));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        String tableNameSuffix = String.valueOf(this.doSharding(this.parseDate(shardingValue.getValue())));
        return this.findMatchedTargetName(availableTargetNames, tableNameSuffix, shardingValue.getDataNodeInfo()).orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size());
        int firstPartition = this.getFirstPartition(shardingValue.getValueRange());
        int lastPartition = this.getLastPartition(shardingValue.getValueRange());
        for (int i = firstPartition; i <= lastPartition; ++i) {
            String suffix = String.valueOf(i);
            this.findMatchedTargetName(availableTargetNames, suffix, shardingValue.getDataNodeInfo()).ifPresent(result::add);
        }
        return result;
    }

    private int doSharding(long shardingValue) {
        String position = new DecimalFormat("0.00").format((double)shardingValue / (double)this.shardingSeconds);
        return Math.min(Math.max(0, (int)Math.ceil(Double.parseDouble(position))), this.autoTablesAmount - 1);
    }

    private int getFirstPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasLowerBound() ? this.doSharding(this.parseDate(valueRange.lowerEndpoint())) : 0;
    }

    private int getLastPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasUpperBound() ? this.doSharding(this.parseDate(valueRange.upperEndpoint())) : this.autoTablesAmount - 1;
    }

    private long parseDate(Comparable<?> shardingValue) {
        LocalDateTime dateValue = LocalDateTime.from(DATE_TIME_FORMAT.parse((CharSequence)shardingValue.toString(), new ParsePosition(0)));
        return Duration.between(this.dateTimeLower, dateValue).toMillis() / 1000L;
    }

    public String getType() {
        return "AUTO_INTERVAL";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public int getAutoTablesAmount() {
        return this.autoTablesAmount;
    }
}

