/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.audit;

import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.check.SQLCheckResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngineFactory;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.spi.ShardingAuditAlgorithm;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;

public final class DMLShardingConditionsShardingAuditAlgorithm
implements ShardingAuditAlgorithm {
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public SQLCheckResult check(SQLStatementContext<?> sqlStatementContext, List<Object> parameters, Grantee grantee, ShardingSphereDatabase database) {
        block4: {
            ShardingRule rule;
            block6: {
                block5: {
                    if (!(sqlStatementContext.getSqlStatement() instanceof DMLStatement)) break block4;
                    rule = (ShardingRule)((List)database.getRuleMetaData().findRules(ShardingRule.class)).get(0);
                    if (rule.isAllBroadcastTables(sqlStatementContext.getTablesContext().getTableNames())) break block5;
                    if (!sqlStatementContext.getTablesContext().getTableNames().stream().noneMatch(rule::isShardingTable)) break block6;
                }
                return new SQLCheckResult(true, "");
            }
            ShardingConditionEngine<?> shardingConditionEngine = ShardingConditionEngineFactory.createShardingConditionEngine(sqlStatementContext, database, rule);
            if (shardingConditionEngine.createShardingConditions(sqlStatementContext, parameters).isEmpty()) {
                return new SQLCheckResult(false, "Not allow DML operation without sharding conditions");
            }
        }
        return new SQLCheckResult(true, "");
    }

    public String getType() {
        return "DML_SHARDING_CONDITIONS";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

