/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.yaml.swapper;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.datanode.YamlDataNode;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlDataNodeRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.path.RuleNodePath;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.metadata.nodepath.ShadowRuleNodePathProvider;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.table.YamlShadowTableConfigurationSwapper;

public final class YamlShadowDataNodeRuleConfigurationSwapper
implements YamlDataNodeRuleConfigurationSwapper<ShadowRuleConfiguration> {
    private final YamlShadowTableConfigurationSwapper tableSwapper = new YamlShadowTableConfigurationSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();
    private final RuleNodePath shadowRuleNodePath = new ShadowRuleNodePathProvider().getRuleNodePath();

    public Collection<YamlDataNode> swapToDataNodes(ShadowRuleConfiguration data) {
        LinkedList<YamlDataNode> result = new LinkedList<YamlDataNode>();
        for (Map.Entry entry : data.getShadowAlgorithms().entrySet()) {
            result.add(new YamlDataNode(this.shadowRuleNodePath.getNamedItem("algorithms").getPath((String)entry.getKey()), YamlEngine.marshal((Object)this.algorithmSwapper.swapToYamlConfiguration((AlgorithmConfiguration)entry.getValue()))));
        }
        if (!Strings.isNullOrEmpty((String)data.getDefaultShadowAlgorithmName())) {
            result.add(new YamlDataNode(this.shadowRuleNodePath.getUniqueItem("default_algorithm_name").getPath(), data.getDefaultShadowAlgorithmName()));
        }
        for (ShadowDataSourceConfiguration each : data.getDataSources()) {
            result.add(new YamlDataNode(this.shadowRuleNodePath.getNamedItem("data_sources").getPath(each.getName()), YamlEngine.marshal((Object)this.swapToDataSourceYamlConfiguration(each))));
        }
        for (Map.Entry entry : data.getTables().entrySet()) {
            result.add(new YamlDataNode(this.shadowRuleNodePath.getNamedItem("tables").getPath((String)entry.getKey()), YamlEngine.marshal((Object)this.tableSwapper.swapToYamlConfiguration((ShadowTableConfiguration)entry.getValue()))));
        }
        return result;
    }

    private YamlShadowDataSourceConfiguration swapToDataSourceYamlConfiguration(ShadowDataSourceConfiguration data) {
        YamlShadowDataSourceConfiguration result = new YamlShadowDataSourceConfiguration();
        result.setProductionDataSourceName(data.getProductionDataSourceName());
        result.setShadowDataSourceName(data.getShadowDataSourceName());
        return result;
    }

    public Optional<ShadowRuleConfiguration> swapToObject(Collection<YamlDataNode> dataNodes) {
        List validDataNodes = dataNodes.stream().filter(each -> this.shadowRuleNodePath.getRoot().isValidatedPath(each.getKey())).collect(Collectors.toList());
        if (validDataNodes.isEmpty()) {
            return Optional.empty();
        }
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        for (YamlDataNode each2 : validDataNodes) {
            this.shadowRuleNodePath.getNamedItem("data_sources").getName(each2.getKey()).ifPresent(optional -> result.getDataSources().add(this.swapDataSource((String)optional, (YamlShadowDataSourceConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlShadowDataSourceConfiguration.class))));
            this.shadowRuleNodePath.getNamedItem("tables").getName(each2.getKey()).ifPresent(optional -> result.getTables().put(optional, this.tableSwapper.swapToObject((YamlShadowTableConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlShadowTableConfiguration.class))));
            this.shadowRuleNodePath.getNamedItem("algorithms").getName(each2.getKey()).ifPresent(optional -> result.getShadowAlgorithms().put(optional, this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlAlgorithmConfiguration.class))));
            if (!this.shadowRuleNodePath.getUniqueItem("default_algorithm_name").isValidatedPath(each2.getKey())) continue;
            result.setDefaultShadowAlgorithmName(each2.getValue());
        }
        return Optional.of(result);
    }

    private ShadowDataSourceConfiguration swapDataSource(String name, YamlShadowDataSourceConfiguration yamlConfig) {
        return new ShadowDataSourceConfiguration(name, yamlConfig.getProductionDataSourceName(), yamlConfig.getShadowDataSourceName());
    }

    public Class<ShadowRuleConfiguration> getTypeClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHADOW";
    }

    public int getOrder() {
        return 50;
    }
}

