/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterNamedRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;

public final class ShadowDataSourceChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShadowRuleConfiguration, ShadowDataSourceConfiguration> {
    public ShadowDataSourceConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        YamlShadowDataSourceConfiguration yamlConfig = (YamlShadowDataSourceConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShadowDataSourceConfiguration.class);
        return new ShadowDataSourceConfiguration(((AlterNamedRuleItemEvent)event).getItemName(), yamlConfig.getProductionDataSourceName(), yamlConfig.getShadowDataSourceName());
    }

    public ShadowRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShadowRule.class).map(ShadowRule::getConfiguration).orElseGet(ShadowRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, ShadowRuleConfiguration currentRuleConfig, ShadowDataSourceConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getDataSources().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getDataSources().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getDataSources().removeIf(each -> each.getName().equals(((DropNamedRuleItemEvent)event).getItemName()));
    }

    public String getType() {
        return "shadow.data_sources";
    }
}

