/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.determiner.HintShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;

public final class ShadowNonDMLStatementRoutingEngine
implements ShadowRouteEngine {
    private final SQLStatementContext sqlStatementContext;

    @Override
    public void route(RouteContext routeContext, ShadowRule rule) {
        this.decorateRouteContext(routeContext, rule, this.findShadowDataSourceMappings(rule));
    }

    private Map<String, String> findShadowDataSourceMappings(ShadowRule rule) {
        Optional<Collection<String>> sqlComments = this.parseSQLComments();
        if (!sqlComments.isPresent()) {
            return Collections.emptyMap();
        }
        if (this.isMatchAnyNoteShadowAlgorithms(rule, this.createShadowDetermineCondition(sqlComments.get()))) {
            return rule.getAllShadowDataSourceMappings();
        }
        return Collections.emptyMap();
    }

    private Optional<Collection<String>> parseSQLComments() {
        Collection result = ((AbstractSQLStatement)this.sqlStatementContext.getSqlStatement()).getCommentSegments().stream().map(CommentSegment::getText).collect(Collectors.toList());
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private ShadowDetermineCondition createShadowDetermineCondition(Collection<String> sqlComments) {
        return new ShadowDetermineCondition("", ShadowOperationType.HINT_MATCH).initSQLComments(sqlComments);
    }

    private boolean isMatchAnyNoteShadowAlgorithms(ShadowRule rule, ShadowDetermineCondition shadowCondition) {
        for (HintShadowAlgorithm<Comparable<?>> each : rule.getAllHintShadowAlgorithms()) {
            if (!HintShadowAlgorithmDeterminer.isShadow(each, shadowCondition, rule)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public ShadowNonDMLStatementRoutingEngine(SQLStatementContext sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

