/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.util.ShadowExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtils;

public final class ShadowUpdateStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final UpdateStatementContext sqlStatementContext;
    private final List<Object> parameters;

    public ShadowUpdateStatementRoutingEngine(UpdateStatementContext sqlStatementContext, List<Object> parameters) {
        super((SQLStatementContext)sqlStatementContext, ShadowOperationType.UPDATE);
        this.sqlStatementContext = sqlStatementContext;
        this.parameters = parameters;
    }

    @Override
    protected Collection<ShadowColumnCondition> getShadowColumnConditions(String shadowColumnName) {
        LinkedList<ShadowColumnCondition> result = new LinkedList<ShadowColumnCondition>();
        for (ExpressionSegment each : this.getWhereSegment()) {
            Collection columns = ColumnExtractor.extract((ExpressionSegment)each);
            if (1 != columns.size()) continue;
            ShadowExtractor.extractValues(each, this.parameters).map(values -> new ShadowColumnCondition(this.getSingleTableName(), shadowColumnName, (Collection<Comparable<?>>)values)).ifPresent(result::add);
        }
        return result;
    }

    private Collection<ExpressionSegment> getWhereSegment() {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.sqlStatementContext.getWhereSegments()) {
            for (AndPredicate predicate : ExpressionExtractUtils.getAndPredicates((ExpressionSegment)each.getExpr())) {
                result.addAll(predicate.getPredicates());
            }
        }
        return result;
    }
}

