/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.exception.syntax.UnsupportedShadowInsertValueException;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;

public final class ShadowInsertStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final InsertStatementContext sqlStatementContext;

    public ShadowInsertStatementRoutingEngine(InsertStatementContext sqlStatementContext) {
        super((SQLStatementContext)sqlStatementContext, ShadowOperationType.INSERT);
        this.sqlStatementContext = sqlStatementContext;
    }

    @Override
    protected Collection<ShadowColumnCondition> getShadowColumnConditions(String shadowColumnName) {
        LinkedList<ShadowColumnCondition> result = new LinkedList<ShadowColumnCondition>();
        int columnIndex = 0;
        for (String each : this.sqlStatementContext.getInsertColumnNames()) {
            if (!shadowColumnName.equals(each)) {
                ++columnIndex;
                continue;
            }
            Collection<Comparable<?>> columnValues = this.getColumnValues(this.sqlStatementContext.getInsertValueContexts(), columnIndex);
            ++columnIndex;
            result.add(new ShadowColumnCondition(this.getSingleTableName(), each, columnValues));
        }
        return result;
    }

    private Collection<Comparable<?>> getColumnValues(List<InsertValueContext> insertValueContexts, int columnIndex) {
        LinkedList result = new LinkedList();
        for (InsertValueContext each : insertValueContexts) {
            Object columnValue = each.getLiteralValue(columnIndex).orElseThrow(() -> new UnsupportedShadowInsertValueException(columnIndex));
            ShardingSpherePreconditions.checkState((boolean)(columnValue instanceof Comparable), () -> new UnsupportedShadowInsertValueException(columnIndex));
            result.add((Comparable)columnValue);
        }
        return result;
    }
}

