/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.determiner.ColumnShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.route.engine.determiner.HintShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public abstract class AbstractShadowDMLStatementRouteEngine
implements ShadowRouteEngine {
    private final SQLStatementContext sqlStatementContext;
    private final ShadowOperationType operationType;
    private final Map<String, String> tableAliasNameMappings = new LinkedHashMap<String, String>();

    @Override
    public final void route(RouteContext routeContext, ShadowRule rule) {
        this.tableAliasNameMappings.putAll(this.getTableAliasNameMappings(((TableAvailable)this.sqlStatementContext).getAllTables()));
        this.decorateRouteContext(routeContext, rule, this.findShadowDataSourceMappings(rule));
    }

    private Map<String, String> getTableAliasNameMappings(Collection<SimpleTableSegment> tableSegments) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (SimpleTableSegment each : tableSegments) {
            String tableName = each.getTableName().getIdentifier().getValue();
            String alias = each.getAliasName().isPresent() ? (String)each.getAliasName().get() : tableName;
            result.put(alias, tableName);
        }
        return result;
    }

    private Map<String, String> findShadowDataSourceMappings(ShadowRule rule) {
        Collection<String> relatedShadowTables = rule.getRelatedShadowTables(this.tableAliasNameMappings.values());
        Collection<String> sqlComments = this.getSQLComments();
        if (relatedShadowTables.isEmpty() && this.isMatchDefaultAlgorithm(rule, sqlComments)) {
            return rule.getAllShadowDataSourceMappings();
        }
        Map<String, String> result = this.findBySQLComments(rule, sqlComments, relatedShadowTables);
        return result.isEmpty() ? this.findByShadowColumn(rule, relatedShadowTables) : result;
    }

    private Collection<String> getSQLComments() {
        SQLStatement sqlStatement = this.sqlStatementContext.getSqlStatement();
        return ((AbstractSQLStatement)sqlStatement).getCommentSegments().stream().map(CommentSegment::getText).collect(Collectors.toList());
    }

    private boolean isMatchDefaultAlgorithm(ShadowRule rule, Collection<String> sqlComments) {
        Optional<ShadowAlgorithm> defaultAlgorithm = rule.getDefaultShadowAlgorithm();
        if (defaultAlgorithm.isPresent() && defaultAlgorithm.get() instanceof HintShadowAlgorithm) {
            ShadowDetermineCondition determineCondition = new ShadowDetermineCondition("", ShadowOperationType.HINT_MATCH);
            return HintShadowAlgorithmDeterminer.isShadow((HintShadowAlgorithm)defaultAlgorithm.get(), determineCondition.initSQLComments(sqlComments), rule);
        }
        return false;
    }

    private Map<String, String> findBySQLComments(ShadowRule rule, Collection<String> sqlComments, Collection<String> relatedShadowTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String each : relatedShadowTables) {
            if (!this.isContainsShadowInSQLComments(rule, each, sqlComments, new ShadowDetermineCondition(each, this.operationType))) continue;
            result.putAll(rule.getRelatedShadowDataSourceMappings(each));
            return result;
        }
        return result;
    }

    private boolean isContainsShadowInSQLComments(ShadowRule rule, String tableName, Collection<String> sqlComments, ShadowDetermineCondition shadowCondition) {
        ShadowDetermineCondition shadowConditionWithComments = shadowCondition.initSQLComments(sqlComments);
        for (HintShadowAlgorithm<Comparable<?>> each : rule.getRelatedHintShadowAlgorithms(tableName)) {
            if (!HintShadowAlgorithmDeterminer.isShadow(each, shadowConditionWithComments, rule)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> findByShadowColumn(ShadowRule rule, Collection<String> relatedShadowTables) {
        for (String each : relatedShadowTables) {
            Collection<String> relatedShadowColumnNames = rule.getRelatedShadowColumnNames(this.operationType, each);
            if (relatedShadowColumnNames.isEmpty() || !this.isMatchAnyColumnShadowAlgorithms(rule, each, relatedShadowColumnNames)) continue;
            return rule.getRelatedShadowDataSourceMappings(each);
        }
        return Collections.emptyMap();
    }

    private boolean isMatchAnyColumnShadowAlgorithms(ShadowRule rule, String shadowTable, Collection<String> shadowColumnNames) {
        for (String each : shadowColumnNames) {
            if (!this.isMatchAnyColumnShadowAlgorithms(rule, shadowTable, each)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchAnyColumnShadowAlgorithms(ShadowRule rule, String shadowTable, String shadowColumn) {
        Collection<ColumnShadowAlgorithm<Comparable<?>>> columnShadowAlgorithms = rule.getRelatedColumnShadowAlgorithms(this.operationType, shadowTable, shadowColumn);
        if (columnShadowAlgorithms.isEmpty()) {
            return false;
        }
        for (ShadowColumnCondition each : this.getShadowColumnConditions(shadowColumn)) {
            if (!this.isMatchColumnShadowAlgorithm(shadowTable, columnShadowAlgorithms, each)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchColumnShadowAlgorithm(String shadowTable, Collection<ColumnShadowAlgorithm<Comparable<?>>> algorithms, ShadowColumnCondition condition) {
        for (ColumnShadowAlgorithm<Comparable<?>> each : algorithms) {
            if (!ColumnShadowAlgorithmDeterminer.isShadow(each, new ShadowDetermineCondition(shadowTable, this.operationType).initShadowColumnCondition(condition))) continue;
            return true;
        }
        return false;
    }

    protected abstract Collection<ShadowColumnCondition> getShadowColumnConditions(String var1);

    protected final String getSingleTableName() {
        return this.tableAliasNameMappings.entrySet().iterator().next().getValue();
    }

    @Generated
    protected AbstractShadowDMLStatementRouteEngine(SQLStatementContext sqlStatementContext, ShadowOperationType operationType) {
        this.sqlStatementContext = sqlStatementContext;
        this.operationType = operationType;
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public ShadowOperationType getOperationType() {
        return this.operationType;
    }

    @Generated
    public Map<String, String> getTableAliasNameMappings() {
        return this.tableAliasNameMappings;
    }
}

