/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.determiner;

import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.hint.PreciseHintShadowValue;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class HintShadowAlgorithmDeterminer {
    public static boolean isShadow(HintShadowAlgorithm<Comparable<?>> shadowAlgorithm, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        Collection<PreciseHintShadowValue<Comparable<?>>> noteShadowValues = HintShadowAlgorithmDeterminer.createNoteShadowValues(shadowCondition);
        for (PreciseHintShadowValue<Comparable<?>> each : noteShadowValues) {
            if (!shadowAlgorithm.isShadow(shadowRule.getAllShadowTableNames(), each)) continue;
            return true;
        }
        return false;
    }

    private static Collection<PreciseHintShadowValue<Comparable<?>>> createNoteShadowValues(ShadowDetermineCondition shadowDetermineCondition) {
        ShadowOperationType shadowOperationType = shadowDetermineCondition.getShadowOperationType();
        String tableName = shadowDetermineCondition.getTableName();
        return shadowDetermineCondition.getSqlComments().stream().map(each -> new PreciseHintShadowValue(tableName, shadowOperationType, (Comparable)((Object)each))).collect(Collectors.toList());
    }

    @Generated
    private HintShadowAlgorithmDeterminer() {
    }
}

