/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.determiner;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.column.PreciseColumnShadowValue;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;

public final class ColumnShadowAlgorithmDeterminer {
    public static boolean isShadow(ColumnShadowAlgorithm<Comparable<?>> shadowAlgorithm, ShadowDetermineCondition shadowCondition) {
        ShadowColumnCondition shadowColumnCondition = shadowCondition.getShadowColumnCondition();
        String tableName = shadowCondition.getTableName();
        ShadowOperationType operationType = shadowCondition.getShadowOperationType();
        for (PreciseColumnShadowValue<Comparable<?>> each : ColumnShadowAlgorithmDeterminer.createColumnShadowValues(shadowColumnCondition.getColumn(), shadowColumnCondition.getValues(), tableName, operationType)) {
            if (tableName.equals(shadowColumnCondition.getOwner()) && shadowAlgorithm.isShadow(each)) continue;
            return false;
        }
        return true;
    }

    private static Collection<PreciseColumnShadowValue<Comparable<?>>> createColumnShadowValues(String columnName, Collection<Comparable<?>> columnValues, String tableName, ShadowOperationType operationType) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : columnValues) {
            result.add(new PreciseColumnShadowValue(tableName, operationType, columnName, each));
        }
        return result;
    }

    @Generated
    private ColumnShadowAlgorithmDeterminer() {
    }
}

