/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.checker;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.EmptyAlgorithmException;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.exception.metadata.MissingRequiredProductionDataSourceException;
import org.apache.shardingsphere.shadow.exception.metadata.MissingRequiredShadowDataSourceException;
import org.apache.shardingsphere.shadow.exception.metadata.NotImplementHintShadowAlgorithmException;
import org.apache.shardingsphere.shadow.exception.metadata.ShadowDataSourceMappingNotFoundException;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public final class ShadowRuleConfigurationChecker
implements RuleConfigurationChecker<ShadowRuleConfiguration> {
    public void check(String databaseName, ShadowRuleConfiguration ruleConfig, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.checkShadowAlgorithms(ruleConfig.getShadowAlgorithms());
        this.checkDefaultShadowAlgorithmConfiguration(ruleConfig.getDefaultShadowAlgorithmName(), ruleConfig.getShadowAlgorithms());
        this.checkDataSources(ruleConfig.getDataSources(), dataSourceMap, databaseName);
        this.checkShadowTableDataSourcesReferences(ruleConfig.getTables(), ruleConfig.getDataSources());
        this.checkShadowTableAlgorithmsReferences(ruleConfig.getTables(), ruleConfig.getShadowAlgorithms(), databaseName);
    }

    private void checkShadowAlgorithms(Map<String, AlgorithmConfiguration> shadowAlgorithmConfigs) {
        shadowAlgorithmConfigs.values().forEach(each -> TypedSPILoader.checkService(ShadowAlgorithm.class, (Object)each.getType(), (Properties)each.getProps()));
    }

    private void checkDataSources(Collection<ShadowDataSourceConfiguration> shadowDataSources, Map<String, DataSource> dataSourceMap, String databaseName) {
        for (ShadowDataSourceConfiguration each : shadowDataSources) {
            ShardingSpherePreconditions.checkState((boolean)dataSourceMap.containsKey(each.getProductionDataSourceName()), () -> new MissingRequiredProductionDataSourceException(databaseName));
            ShardingSpherePreconditions.checkState((boolean)dataSourceMap.containsKey(each.getShadowDataSourceName()), () -> new MissingRequiredShadowDataSourceException(databaseName));
        }
    }

    private void checkShadowTableDataSourcesReferences(Map<String, ShadowTableConfiguration> shadowTables, Collection<ShadowDataSourceConfiguration> shadowDataSources) {
        Collection dataSourceNames = shadowDataSources.stream().map(ShadowDataSourceConfiguration::getName).collect(Collectors.toSet());
        shadowTables.forEach((key, value) -> {
            for (String each : value.getDataSourceNames()) {
                ShardingSpherePreconditions.checkState((boolean)dataSourceNames.contains(each), () -> new ShadowDataSourceMappingNotFoundException((String)key));
            }
        });
    }

    private void checkDefaultShadowAlgorithmConfiguration(String defaultShadowAlgorithmName, Map<String, AlgorithmConfiguration> shadowAlgorithmConfigs) {
        if (null != defaultShadowAlgorithmName) {
            AlgorithmConfiguration algorithmConfig = shadowAlgorithmConfigs.get(defaultShadowAlgorithmName);
            ShardingSpherePreconditions.checkState((null != algorithmConfig && "SQL_HINT".equals(algorithmConfig.getType()) ? 1 : 0) != 0, NotImplementHintShadowAlgorithmException::new);
        }
    }

    private void checkShadowTableAlgorithmsReferences(Map<String, ShadowTableConfiguration> shadowTables, Map<String, AlgorithmConfiguration> shadowAlgorithms, String databaseName) {
        for (ShadowTableConfiguration each : shadowTables.values()) {
            ShardingSpherePreconditions.checkState((!each.getShadowAlgorithmNames().isEmpty() ? 1 : 0) != 0, () -> new EmptyAlgorithmException("Shadow", new SQLExceptionIdentifier(databaseName)));
            each.getShadowAlgorithmNames().forEach(shadowAlgorithmName -> ShardingSpherePreconditions.checkState((boolean)shadowAlgorithms.containsKey(shadowAlgorithmName), () -> new EmptyAlgorithmException("Shadow", new SQLExceptionIdentifier(databaseName))));
        }
    }

    public Collection<String> getRequiredDataSourceNames(ShadowRuleConfiguration ruleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ruleConfig.getDataSources().forEach(each -> {
            if (null != each.getShadowDataSourceName()) {
                result.add(each.getShadowDataSourceName());
            }
            if (null != each.getProductionDataSourceName()) {
                result.add(each.getProductionDataSourceName());
            }
        });
        return result;
    }

    public int getOrder() {
        return 50;
    }

    public Class<ShadowRuleConfiguration> getTypeClass() {
        return ShadowRuleConfiguration.class;
    }
}

